/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.conversion;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.conversion.TypeConverter;
import com.jxdinfo.conversion.exception.ConversionException;
import com.jxdinfo.conversion.utils.ElementParserUtil;
import com.jxdinfo.hutool.core.lang.Assert;
import com.jxdinfo.hutool.core.util.StrUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.OrderComparator;

public class TypeConverterProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(TypeConverterProcessor.class);
    private final List<TypeConverter<?, ?>> sortedConverterList;
    private final Map<String, TypeConverter<?, ?>> typeConverterMap = new HashMap();

    public TypeConverterProcessor(List<TypeConverter<?, ?>> converterList) {
        if (CollectionUtils.isEmpty(converterList)) {
            this.sortedConverterList = new ArrayList();
            return;
        }
        converterList.forEach(converter -> {
            Assert.notNull(converter.getSourceType(), "SourceType is not allowed to be null. name: {}", converter.getConvertName());
            Assert.notNull(converter.getTargetType(), "TargetType is not allowed to be null. name: {}", converter.getConvertName());
            Assert.notBlank(converter.getConvertName(), "ConvertName is not allowed to be blank. name: {}", converter.getConvertName());
            this.typeConverterMap.put(converter.getConvertName().toUpperCase(), (TypeConverter<?, ?>)converter);
        });
        OrderComparator.sort(converterList);
        this.sortedConverterList = converterList;
    }

    public <S, T> Pair<String, T> convert(S source, Class<T> targetType) {
        return this.convert(null, source, targetType);
    }

    public <S, T> Pair<String, T> convert(String convertName, S source) {
        return this.convert(convertName, source, null);
    }

    public <S, T> Pair<String, T> convert(String convertName, S source, Class<T> targetType) {
        return this.convert(convertName, source, targetType, null);
    }

    public <S, T> Pair<String, T> convert(String convertName, S source, Class<T> targetType, Class<?> collGeneric) {
        TypeConverter<?, ?> typeConverterObj;
        if (source instanceof Optional) {
            source = ((Optional)source).orElse(null);
        }
        if (source == null) {
            if (targetType != null && targetType.isPrimitive()) {
                return ImmutablePair.of(null, (Object)ElementParserUtil.initPrimitive(targetType));
            }
            return ImmutablePair.nullPair();
        }
        if (StringUtils.isBlank((CharSequence)convertName)) {
            if (targetType == null || Objects.equals("void", targetType.getName())) {
                return ImmutablePair.of(null, source);
            }
            if (ElementParserUtil.isAssignable(targetType, source.getClass()) && this.notCollectionTransfer(source, targetType, collGeneric)) {
                return ImmutablePair.of(null, source);
            }
            convertName = this.getMustMatchedConverter(source, targetType, collGeneric);
            if (StringUtils.isBlank((CharSequence)convertName)) {
                return ImmutablePair.of(null, source);
            }
        }
        if ((typeConverterObj = this.typeConverterMap.get(convertName.toUpperCase())) == null) {
            return ImmutablePair.of(null, source);
        }
        TypeConverter<?, ?> typeConverter = typeConverterObj;
        if (!ElementParserUtil.isAssignable(typeConverter.getSourceType(), source.getClass())) {
            LOGGER.warn("The actual specified type converter cannot take effect! converter name: {}, actual source type: {}, converter source type: {}", new Object[]{typeConverter.getConvertName(), source.getClass(), typeConverter.getSourceType()});
            return ImmutablePair.of(null, source);
        }
        if (targetType != null && !ElementParserUtil.isAssignable(typeConverter.getTargetType(), targetType)) {
            LOGGER.warn("The actual specified type converter cannot take effect! converter name: {}, actual target type: {}, converter target type: {}", new Object[]{typeConverter.getConvertName(), targetType, typeConverter.getTargetType()});
            return ImmutablePair.of(null, source);
        }
        try {
            return ImmutablePair.of((Object)convertName, Optional.of(source).map(s -> typeConverter.convert(s, targetType, collGeneric)).orElse(null));
        }
        catch (Exception e) {
            throw new ConversionException(StrUtil.format("TypeConverterProcessor converter exception. converter name: {}, source: {}, targetType: {}", typeConverter.getConvertName(), source, targetType));
        }
    }

    private <S, T> boolean notCollectionTransfer(S source, Class<T> targetType, Class<?> collGeneric) {
        if (collGeneric == null) {
            return true;
        }
        return !(source instanceof Set) && !(source instanceof List) || !List.class.isAssignableFrom(targetType) && !Set.class.isAssignableFrom(targetType);
    }

    private <S, T> String getMustMatchedConverter(S source, Class<T> targetType, Class<?> collGeneric) {
        List converterNames = this.sortedConverterList.stream().filter(c -> c.match(source, targetType, collGeneric)).map(TypeConverter::getConvertName).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(converterNames)) {
            return "";
        }
        if (converterNames.size() > 1) {
            LOGGER.debug("MustMatchedConverter sourceType: {}, targetType: {}. The name of the converter that can be used is: {}, practical use of the first!", new Object[]{source.getClass().getName(), targetType.getName(), JSON.toJSONString(converterNames)});
        }
        return (String)converterNames.get(0);
    }
}

