/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.liteflow.flow;

import com.jxdinfo.hutool.core.collection.ListUtil;
import com.jxdinfo.hutool.core.util.StrUtil;
import com.jxdinfo.liteflow.annotation.FallbackCmp;
import com.jxdinfo.liteflow.annotation.util.AnnoUtil;
import com.jxdinfo.liteflow.builder.el.LiteFlowChainELBuilder;
import com.jxdinfo.liteflow.core.ComponentInitializer;
import com.jxdinfo.liteflow.core.NodeComponent;
import com.jxdinfo.liteflow.core.ScriptComponent;
import com.jxdinfo.liteflow.core.proxy.DeclWarpBean;
import com.jxdinfo.liteflow.core.proxy.LiteFlowProxyUtil;
import com.jxdinfo.liteflow.enums.FlowParserTypeEnum;
import com.jxdinfo.liteflow.enums.NodeTypeEnum;
import com.jxdinfo.liteflow.exception.ComponentCannotRegisterException;
import com.jxdinfo.liteflow.exception.NullNodeTypeException;
import com.jxdinfo.liteflow.flow.element.Chain;
import com.jxdinfo.liteflow.flow.element.Node;
import com.jxdinfo.liteflow.log.LFLog;
import com.jxdinfo.liteflow.log.LFLoggerManager;
import com.jxdinfo.liteflow.parser.el.LocalJsonFlowELParser;
import com.jxdinfo.liteflow.parser.el.LocalXmlFlowELParser;
import com.jxdinfo.liteflow.parser.el.LocalYmlFlowELParser;
import com.jxdinfo.liteflow.property.LiteflowConfig;
import com.jxdinfo.liteflow.property.LiteflowConfigGetter;
import com.jxdinfo.liteflow.script.ScriptExecutorFactory;
import com.jxdinfo.liteflow.script.exception.ScriptLoadException;
import com.jxdinfo.liteflow.script.exception.ScriptSpiException;
import com.jxdinfo.liteflow.spi.ContextAware;
import com.jxdinfo.liteflow.spi.holder.ContextAwareHolder;
import com.jxdinfo.liteflow.spi.holder.DeclComponentParserHolder;
import com.jxdinfo.liteflow.util.CopyOnWriteHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;

public class FlowBus {
    private static final LFLog LOG = LFLoggerManager.getLogger(FlowBus.class);
    private static final Map<String, Chain> chainMap;
    private static final Map<String, Node> nodeMap;
    private static final Map<String, Node> fallbackNodeMap;
    private static final AtomicBoolean initStat;

    public static Chain getChain(String id) {
        return chainMap.get(id);
    }

    public static void addChain(String chainName) {
        if (!chainMap.containsKey(chainName)) {
            chainMap.put(chainName, new Chain(chainName));
        }
    }

    public static void addChain(Chain chain) {
        chainMap.put(chain.getChainId(), chain);
    }

    public static boolean containChain(String chainId) {
        return chainMap.containsKey(chainId);
    }

    public static boolean needInit() {
        return initStat.compareAndSet(false, true);
    }

    public static boolean containNode(String nodeId) {
        return nodeMap.containsKey(nodeId);
    }

    public static void addManagedNode(String nodeId) {
        ContextAware contextAware = ContextAwareHolder.loadContextAware();
        if (contextAware.hasBean(nodeId)) {
            FlowBus.addManagedNode(nodeId, (NodeComponent)contextAware.getBean(nodeId));
        }
    }

    public static void addManagedNode(String nodeId, NodeComponent nodeComponent) {
        NodeTypeEnum type = NodeTypeEnum.guessType(nodeComponent.getClass());
        if (type == null) {
            throw new NullNodeTypeException(StrUtil.format("node type is null for node[{}]", nodeId));
        }
        Node node = new Node(ComponentInitializer.loadInstance().initComponent(nodeComponent, type, nodeComponent.getName(), nodeId));
        nodeMap.put(nodeId, node);
        FlowBus.addFallbackNode(node);
    }

    public static void addNode(String nodeId, String name, NodeTypeEnum type, Class<?> cmpClazz) {
        FlowBus.addNode(nodeId, name, type, cmpClazz, null, null);
    }

    public static void addNode(String nodeId, String name, NodeTypeEnum nodeType, String cmpClazzStr) {
        Class<?> cmpClazz;
        try {
            cmpClazz = Class.forName(cmpClazzStr);
        }
        catch (Exception e) {
            throw new ComponentCannotRegisterException(e.getMessage());
        }
        FlowBus.addNode(nodeId, name, nodeType, cmpClazz, null, null);
    }

    public static void addScriptNode(String nodeId, String name, NodeTypeEnum nodeType, String script, String language) {
        FlowBus.addNode(nodeId, name, nodeType, ScriptComponent.ScriptComponentClassMap.get((Object)nodeType), script, language);
    }

    private static void addNode(String nodeId, String name, NodeTypeEnum type, Class<?> cmpClazz, String script, String language) {
        try {
            List<Object> cmpInstanceList = new ArrayList<NodeComponent>();
            if (LiteFlowProxyUtil.isDeclareCmp(cmpClazz)) {
                List<DeclWarpBean> declWarpBeanList = DeclComponentParserHolder.loadDeclComponentParser().parseDeclBean(cmpClazz, nodeId, name);
                cmpInstanceList = declWarpBeanList.stream().map(declWarpBean -> (NodeComponent)ContextAwareHolder.loadContextAware().registerDeclWrapBean(nodeId, (DeclWarpBean)declWarpBean)).collect(Collectors.toList());
            } else {
                if (!type.isScript()) {
                    cmpInstanceList = ListUtil.toList((NodeComponent)ContextAwareHolder.loadContextAware().registerOrGet(nodeId, cmpClazz));
                }
                if (cmpInstanceList.isEmpty()) {
                    NodeComponent cmpInstance2 = (NodeComponent)cmpClazz.newInstance();
                    cmpInstanceList.add(cmpInstance2);
                }
            }
            cmpInstanceList = cmpInstanceList.stream().map(cmpInstance -> ComponentInitializer.loadInstance().initComponent((NodeComponent)cmpInstance, type, name, cmpInstance.getNodeId() == null ? nodeId : cmpInstance.getNodeId())).collect(Collectors.toList());
            List nodes = cmpInstanceList.stream().map(Node::new).collect(Collectors.toList());
            for (int i = 0; i < nodes.size(); ++i) {
                Node node = (Node)nodes.get(i);
                NodeComponent cmpInstance3 = (NodeComponent)cmpInstanceList.get(i);
                if (type.isScript()) {
                    if (StrUtil.isNotBlank(script)) {
                        node.setScript(script);
                        node.setLanguage(language);
                        ((ScriptComponent)((Object)cmpInstance3)).loadScript(script, language);
                    } else {
                        String errorMsg = StrUtil.format("script for node[{}] is empty", nodeId);
                        throw new ScriptLoadException(errorMsg);
                    }
                }
                String activeNodeId = StrUtil.isEmpty(cmpInstance3.getNodeId()) ? nodeId : cmpInstance3.getNodeId();
                nodeMap.put(activeNodeId, node);
                FlowBus.addFallbackNode(node);
            }
        }
        catch (Exception e) {
            String error = StrUtil.format("component[{}] register error", StrUtil.isEmpty(name) ? nodeId : StrUtil.format("{}({})", nodeId, name));
            LOG.error(e.getMessage());
            throw new ComponentCannotRegisterException(StrUtil.format("{} {}", error, e.getMessage()));
        }
    }

    public static Node getNode(String nodeId) {
        return nodeMap.get(nodeId);
    }

    public static List<Node> getNodesByChainId(String chainId) {
        Chain chain = FlowBus.getChain(chainId);
        return chain.getConditionList().stream().flatMap(condition -> condition.getAllNodeInCondition().stream()).collect(Collectors.toList());
    }

    public static Map<String, Node> getNodeMap() {
        return nodeMap;
    }

    public static Map<String, Chain> getChainMap() {
        return chainMap;
    }

    public static Node getFallBackNode(NodeTypeEnum nodeType) {
        String key = StrUtil.format("FB_{}", nodeType.name());
        return fallbackNodeMap.get(key);
    }

    public static void cleanCache() {
        chainMap.clear();
        nodeMap.clear();
        fallbackNodeMap.clear();
        FlowBus.cleanScriptCache();
    }

    public static void cleanScriptCache() {
        try {
            ScriptExecutorFactory.loadInstance().cleanScriptCache();
        }
        catch (ScriptSpiException scriptSpiException) {
            // empty catch block
        }
    }

    public static void refreshFlowMetaData(FlowParserTypeEnum type, String content) throws Exception {
        if (type.equals((Object)FlowParserTypeEnum.TYPE_EL_XML)) {
            new LocalXmlFlowELParser().parse(content);
        } else if (type.equals((Object)FlowParserTypeEnum.TYPE_EL_JSON)) {
            new LocalJsonFlowELParser().parse(content);
        } else if (type.equals((Object)FlowParserTypeEnum.TYPE_EL_YML)) {
            new LocalYmlFlowELParser().parse(content);
        }
    }

    public static boolean removeChain(String chainId) {
        if (FlowBus.containChain(chainId)) {
            chainMap.remove(chainId);
            return true;
        }
        String errMsg = StrUtil.format("cannot find the chain[{}]", chainId);
        LOG.error(errMsg);
        return false;
    }

    public static void removeChain(String ... chainIds) {
        Arrays.stream(chainIds).forEach(FlowBus::removeChain);
    }

    public static boolean removeNode(String nodeId) {
        return nodeMap.remove(nodeId) != null;
    }

    private static void addFallbackNode(Node node) {
        NodeComponent nodeComponent = node.getInstance();
        FallbackCmp fallbackCmp = AnnoUtil.getAnnotation(nodeComponent.getClass(), FallbackCmp.class);
        if (fallbackCmp == null) {
            return;
        }
        NodeTypeEnum nodeType = node.getType();
        String key = StrUtil.format("FB_{}", nodeType.name());
        fallbackNodeMap.put(key, node);
    }

    public static void reloadScript(String nodeId, String script) {
        Node node = FlowBus.getNode(nodeId);
        if (node == null || !node.getType().isScript()) {
            return;
        }
        node.setScript(script);
        ScriptExecutorFactory.loadInstance().getScriptExecutor(node.getLanguage()).load(nodeId, script);
    }

    public static boolean unloadScriptNode(String nodeId) {
        Node node = FlowBus.getNode(nodeId);
        if (node == null || !node.getType().isScript()) {
            return false;
        }
        ScriptExecutorFactory.loadInstance().getScriptExecutor(node.getLanguage()).unLoad(nodeId);
        return FlowBus.removeNode(nodeId);
    }

    public static void reloadChain(String chainId, String elContent) {
        FlowBus.reloadChain(chainId, elContent, null);
    }

    public static void reloadChain(String chainId, String elContent, String routeContent) {
        LiteFlowChainELBuilder.createChain().setChainId(chainId).setEL(elContent).setRoute(routeContent).build();
    }

    public static void clearStat() {
        initStat.set(false);
    }

    static {
        initStat = new AtomicBoolean(false);
        LiteflowConfig liteflowConfig = LiteflowConfigGetter.get();
        if (liteflowConfig.getFastLoad().booleanValue()) {
            chainMap = new HashMap<String, Chain>();
            nodeMap = new HashMap<String, Node>();
            fallbackNodeMap = new HashMap<String, Node>();
        } else {
            chainMap = new CopyOnWriteHashMap<String, Chain>();
            nodeMap = new CopyOnWriteHashMap<String, Node>();
            fallbackNodeMap = new CopyOnWriteHashMap<String, Node>();
        }
    }
}

