/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hutool.core.convert.impl;

import com.jxdinfo.hutool.core.bean.BeanUtil;
import com.jxdinfo.hutool.core.convert.AbstractConverter;
import com.jxdinfo.hutool.core.convert.ConvertException;
import com.jxdinfo.hutool.core.convert.ConverterRegistry;
import com.jxdinfo.hutool.core.lang.Pair;
import com.jxdinfo.hutool.core.map.MapUtil;
import com.jxdinfo.hutool.core.util.ReflectUtil;
import com.jxdinfo.hutool.core.util.StrUtil;
import com.jxdinfo.hutool.core.util.TypeUtil;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;

public class EntryConverter
extends AbstractConverter<Map.Entry<?, ?>> {
    private final Type pairType;
    private final Type keyType;
    private final Type valueType;

    public EntryConverter(Type entryType) {
        this(entryType, TypeUtil.getTypeArgument(entryType, 0), TypeUtil.getTypeArgument(entryType, 1));
    }

    public EntryConverter(Type entryType, Type keyType, Type valueType) {
        this.pairType = entryType;
        this.keyType = keyType;
        this.valueType = valueType;
    }

    @Override
    protected Map.Entry<?, ?> convertInternal(Object value) {
        Map<Object, Object> map = null;
        if (value instanceof Pair) {
            Pair pair = (Pair)value;
            map = MapUtil.of(pair.getKey(), pair.getValue());
        } else if (value instanceof Map) {
            map = (HashMap)value;
        } else if (value instanceof CharSequence) {
            CharSequence str = (CharSequence)value;
            map = EntryConverter.strToMap(str);
        } else if (BeanUtil.isReadableBean(value.getClass())) {
            map = BeanUtil.beanToMap(value, new String[0]);
        }
        if (null != map) {
            return EntryConverter.mapToEntry(this.pairType, this.keyType, this.valueType, map);
        }
        throw new ConvertException("Unsupported to map from [{}] of type: {}", value, value.getClass().getName());
    }

    private static Map<CharSequence, CharSequence> strToMap(CharSequence str) {
        int index = StrUtil.indexOf(str, '=', 0, str.length());
        if (index > -1) {
            return MapUtil.of(str.subSequence(0, index + 1), str.subSequence(index, str.length()));
        }
        return null;
    }

    private static Map.Entry<?, ?> mapToEntry(Type targetType, Type keyType, Type valueType, Map map) {
        Object key = null;
        Object value = null;
        if (1 == map.size()) {
            Map.Entry entry = map.entrySet().iterator().next();
            key = entry.getKey();
            value = entry.getValue();
        } else if (2 == map.size()) {
            key = map.get("key");
            value = map.get("value");
        }
        ConverterRegistry convert = ConverterRegistry.getInstance();
        return (Map.Entry)ReflectUtil.newInstance(TypeUtil.getClass(targetType), TypeUtil.isUnknown(keyType) ? key : convert.convert(keyType, key), TypeUtil.isUnknown(valueType) ? value : convert.convert(valueType, value));
    }
}

