/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hutool.core.convert.impl;

import com.jxdinfo.hutool.core.convert.AbstractConverter;
import com.jxdinfo.hutool.core.convert.Convert;
import com.jxdinfo.hutool.core.convert.ConvertException;
import com.jxdinfo.hutool.core.convert.impl.NumberConverter;
import com.jxdinfo.hutool.core.util.ObjectUtil;
import com.jxdinfo.hutool.core.util.StrUtil;
import java.util.function.Function;

public class PrimitiveConverter
extends AbstractConverter<Object> {
    private static final long serialVersionUID = 1L;
    private final Class<?> targetType;

    public PrimitiveConverter(Class<?> clazz) {
        if (null == clazz) {
            throw new NullPointerException("PrimitiveConverter not allow null target type!");
        }
        if (!clazz.isPrimitive()) {
            throw new IllegalArgumentException("[" + clazz + "] is not a primitive class!");
        }
        this.targetType = clazz;
    }

    @Override
    protected Object convertInternal(Object value) {
        return PrimitiveConverter.convert(value, this.targetType, this::convertToStr);
    }

    @Override
    protected String convertToStr(Object value) {
        return StrUtil.trim(super.convertToStr(value));
    }

    @Override
    public Class<Object> getTargetType() {
        return this.targetType;
    }

    protected static Object convert(Object value, Class<?> primitiveClass, Function<Object, String> toStringFunc) {
        if (Byte.TYPE == primitiveClass) {
            return ObjectUtil.defaultIfNull(NumberConverter.convert(value, Byte.class, toStringFunc), 0);
        }
        if (Short.TYPE == primitiveClass) {
            return ObjectUtil.defaultIfNull(NumberConverter.convert(value, Short.class, toStringFunc), 0);
        }
        if (Integer.TYPE == primitiveClass) {
            return ObjectUtil.defaultIfNull(NumberConverter.convert(value, Integer.class, toStringFunc), 0);
        }
        if (Long.TYPE == primitiveClass) {
            return ObjectUtil.defaultIfNull(NumberConverter.convert(value, Long.class, toStringFunc), 0);
        }
        if (Float.TYPE == primitiveClass) {
            return ObjectUtil.defaultIfNull(NumberConverter.convert(value, Float.class, toStringFunc), 0);
        }
        if (Double.TYPE == primitiveClass) {
            return ObjectUtil.defaultIfNull(NumberConverter.convert(value, Double.class, toStringFunc), 0);
        }
        if (Character.TYPE == primitiveClass) {
            return Convert.convert(Character.class, value);
        }
        if (Boolean.TYPE == primitiveClass) {
            return Convert.convert(Boolean.class, value);
        }
        throw new ConvertException("Unsupported target type: {}", primitiveClass);
    }
}

