/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.conversion.converter;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.jxdinfo.conversion.TypeConverter;
import com.jxdinfo.conversion.utils.ElementParserUtil;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;

public class CollectionGenericTypeConverter
implements TypeConverter<Collection, Collection> {
    @Override
    public boolean match(Object source, Class<?> needType, Class<?> collGeneric) {
        if (!(source instanceof Set) && !(source instanceof List)) {
            return false;
        }
        if (!Set.class.isAssignableFrom(needType) && !List.class.isAssignableFrom(needType)) {
            return false;
        }
        if (CollectionUtils.isEmpty((Collection)((Collection)source)) || collGeneric == null) {
            return false;
        }
        return !ElementParserUtil.isAssignable(collGeneric, ((Collection)source).iterator().next().getClass());
    }

    @Override
    public Collection convert(Collection source, Class<?> needType, Class<?> collGeneric) {
        if (source == null || needType == null || collGeneric == null) {
            return source;
        }
        AbstractCollection collection = List.class.isAssignableFrom(needType) ? new ArrayList() : new HashSet();
        for (Object next : source) {
            String s = next instanceof String ? (String)next : JSON.toJSONString(next, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect});
            collection.add(JSON.parseObject((String)s, collGeneric));
        }
        return collection;
    }

    @Override
    public Collection doConvert(Collection source, Class<?> needType) {
        return null;
    }

    @Override
    public Class<Collection> getSourceType() {
        return Collection.class;
    }

    @Override
    public Class<Collection> getTargetType() {
        return Collection.class;
    }

    @Override
    public String getConvertName() {
        return "COLLECTION_GENERIC_TYPE_CONVERTER";
    }

    @Override
    public int getOrder() {
        return 1000;
    }
}

