/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.liteflow.enums;

import com.jxdinfo.hutool.core.annotation.AnnotationUtil;
import com.jxdinfo.hutool.core.util.StrUtil;
import com.jxdinfo.liteflow.annotation.LiteflowCmpDefine;
import com.jxdinfo.liteflow.annotation.LiteflowMethod;
import com.jxdinfo.liteflow.core.NodeBooleanComponent;
import com.jxdinfo.liteflow.core.NodeComponent;
import com.jxdinfo.liteflow.core.NodeForComponent;
import com.jxdinfo.liteflow.core.NodeIteratorComponent;
import com.jxdinfo.liteflow.core.NodeSwitchComponent;
import com.jxdinfo.liteflow.core.ScriptBooleanComponent;
import com.jxdinfo.liteflow.core.ScriptCommonComponent;
import com.jxdinfo.liteflow.core.ScriptForComponent;
import com.jxdinfo.liteflow.core.ScriptSwitchComponent;
import com.jxdinfo.liteflow.core.proxy.LiteFlowProxyUtil;
import com.jxdinfo.liteflow.log.LFLog;
import com.jxdinfo.liteflow.log.LFLoggerManager;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;

public enum NodeTypeEnum {
    COMMON("common", "\u666e\u901a", false, NodeComponent.class),
    SWITCH("switch", "\u9009\u62e9", false, NodeSwitchComponent.class),
    BOOLEAN("boolean", "\u5e03\u5c14", false, NodeBooleanComponent.class),
    FOR("for", "\u5faa\u73af\u6b21\u6570", false, NodeForComponent.class),
    ITERATOR("iterator", "\u5faa\u73af\u8fed\u4ee3", false, NodeIteratorComponent.class),
    SCRIPT("script", "\u811a\u672c", true, ScriptCommonComponent.class),
    SWITCH_SCRIPT("switch_script", "\u9009\u62e9\u811a\u672c", true, ScriptSwitchComponent.class),
    BOOLEAN_SCRIPT("boolean_script", "\u5e03\u5c14\u811a\u672c", true, ScriptBooleanComponent.class),
    FOR_SCRIPT("for_script", "\u5faa\u73af\u6b21\u6570\u811a\u672c", true, ScriptForComponent.class),
    FALLBACK("fallback", "\u964d\u7ea7", false, null);

    private static final LFLog LOG;
    private String code;
    private String name;
    private boolean isScript;
    private Class<? extends NodeComponent> mappingClazz;

    private NodeTypeEnum(String code, String name, boolean isScript, Class<? extends NodeComponent> mappingClazz) {
        this.code = code;
        this.name = name;
        this.isScript = isScript;
        this.mappingClazz = mappingClazz;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isScript() {
        return this.isScript;
    }

    public void setScript(boolean script) {
        this.isScript = script;
    }

    public Class<? extends NodeComponent> getMappingClazz() {
        return this.mappingClazz;
    }

    public void setMappingClazz(Class<? extends NodeComponent> mappingClazz) {
        this.mappingClazz = mappingClazz;
    }

    public static NodeTypeEnum getEnumByCode(String code) {
        for (NodeTypeEnum e : NodeTypeEnum.values()) {
            if (!e.getCode().equals(code)) continue;
            return e;
        }
        return null;
    }

    public static NodeTypeEnum guessTypeBySuperClazz(Class<?> clazz) {
        Class<?> superClazz = clazz;
        while (!(superClazz = superClazz.getSuperclass()).getPackage().getName().startsWith("com.jxdinfo.liteflow.core")) {
            if (!superClazz.equals(Object.class)) continue;
            return null;
        }
        for (NodeTypeEnum e : NodeTypeEnum.values()) {
            if (e.getMappingClazz() == null || !e.getMappingClazz().equals(superClazz)) continue;
            return e;
        }
        return null;
    }

    public static NodeTypeEnum guessType(Class<?> clazz) {
        NodeTypeEnum nodeType;
        if (LiteFlowProxyUtil.isCglibProxyClass(clazz)) {
            clazz = LiteFlowProxyUtil.getUserClass(clazz);
        }
        if ((nodeType = NodeTypeEnum.guessTypeBySuperClazz(clazz)) == null) {
            LiteflowCmpDefine liteflowCmpDefine = clazz.getAnnotation(LiteflowCmpDefine.class);
            if (liteflowCmpDefine != null) {
                boolean mixDefined = Arrays.stream(clazz.getDeclaredMethods()).anyMatch(method -> {
                    LiteflowMethod liteflowMethod = AnnotationUtil.getAnnotation(method, LiteflowMethod.class);
                    if (liteflowMethod != null) {
                        return StrUtil.isNotBlank(liteflowMethod.nodeId());
                    }
                    return false;
                });
                if (mixDefined) {
                    LOG.warn("[[[WARNING!!!]]]The @liteflowMethod in the class[{}] defined by @liteflowCmpDefine should not configure the nodeId again!", (Object)clazz.getName());
                }
                AtomicReference differenceTypeMethod = new AtomicReference();
                boolean hasDifferenceNodeType = Arrays.stream(clazz.getDeclaredMethods()).anyMatch(method -> {
                    LiteflowMethod liteflowMethod = AnnotationUtil.getAnnotation(method, LiteflowMethod.class);
                    if (liteflowMethod != null) {
                        if (!liteflowMethod.nodeType().equals((Object)liteflowCmpDefine.value())) {
                            differenceTypeMethod.set(method);
                            return true;
                        }
                        return false;
                    }
                    return false;
                });
                if (hasDifferenceNodeType) {
                    LOG.warn("[[[WARNING!!!]]]The nodeType in @liteflowCmpDefine declared on the class[{}] does not match the nodeType in @liteflowMethod declared on the method[{}]!", (Object)clazz.getName(), (Object)((Method)differenceTypeMethod.get()).getName());
                }
                return liteflowCmpDefine.value();
            }
            LiteflowMethod liteflowMethod = Arrays.stream(clazz.getDeclaredMethods()).map(method -> AnnotationUtil.getAnnotation(method, LiteflowMethod.class)).filter(Objects::nonNull).filter(lfMethod -> lfMethod.value().isMainMethod()).findFirst().orElse(null);
            if (liteflowMethod != null) {
                nodeType = liteflowMethod.nodeType();
            }
        }
        return nodeType;
    }

    static {
        LOG = LFLoggerManager.getLogger(NodeTypeEnum.class);
    }
}

