/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hutool.crypto;

import com.jxdinfo.hutool.crypto.CryptoException;
import com.jxdinfo.hutool.crypto.GlobalBouncyCastleProvider;
import com.jxdinfo.hutool.crypto.digest.MD5;
import java.io.File;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import javax.crypto.Cipher;

public class SecureUtil {
    public static MD5 md5() {
        return new MD5();
    }

    public static String md5(String data) {
        return new MD5().digestHex(data);
    }

    public static String md5(InputStream data) {
        return new MD5().digestHex(data);
    }

    public static String md5(File dataFile) {
        return new MD5().digestHex(dataFile);
    }

    public static void addProvider(Provider provider) {
        Security.insertProviderAt(provider, 0);
    }

    public static Cipher createCipher(String algorithm) {
        Cipher cipher;
        Provider provider = GlobalBouncyCastleProvider.INSTANCE.getProvider();
        try {
            cipher = null == provider ? Cipher.getInstance(algorithm) : Cipher.getInstance(algorithm, provider);
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
        return cipher;
    }

    public static MessageDigest createMessageDigest(String algorithm) {
        MessageDigest messageDigest;
        Provider provider = GlobalBouncyCastleProvider.INSTANCE.getProvider();
        try {
            messageDigest = null == provider ? MessageDigest.getInstance(algorithm) : MessageDigest.getInstance(algorithm, provider);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoException(e);
        }
        return messageDigest;
    }

    public static MessageDigest createJdkMessageDigest(String algorithm) {
        try {
            return MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoException(e);
        }
    }
}

