/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.liteflow.flow.executor;

import com.jxdinfo.hutool.core.map.MapUtil;
import com.jxdinfo.hutool.core.util.ObjectUtil;
import com.jxdinfo.liteflow.flow.executor.DefaultNodeExecutor;
import com.jxdinfo.liteflow.flow.executor.NodeExecutor;
import com.jxdinfo.liteflow.spi.holder.ContextAwareHolder;
import java.util.Map;

public class NodeExecutorHelper {
    private final Map<Class<? extends NodeExecutor>, NodeExecutor> nodeExecutorMap = MapUtil.newConcurrentHashMap();

    private NodeExecutorHelper() {
    }

    public static NodeExecutorHelper loadInstance() {
        return Holder.INSTANCE;
    }

    public NodeExecutor buildNodeExecutor(Class<? extends NodeExecutor> nodeExecutorClass) {
        NodeExecutor nodeExecutor;
        if (nodeExecutorClass == null) {
            nodeExecutorClass = DefaultNodeExecutor.class;
        }
        if (ObjectUtil.isNull(nodeExecutor = this.nodeExecutorMap.get(nodeExecutorClass))) {
            nodeExecutor = ContextAwareHolder.loadContextAware().registerBean(nodeExecutorClass);
            this.nodeExecutorMap.put(nodeExecutorClass, nodeExecutor);
        }
        return this.nodeExecutorMap.get(nodeExecutorClass);
    }

    private static class Holder {
        static final NodeExecutorHelper INSTANCE = new NodeExecutorHelper();

        private Holder() {
        }
    }
}

