/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.liteflow.flow.element.condition;

import com.jxdinfo.hutool.core.text.StrFormatter;
import com.jxdinfo.hutool.core.util.ObjectUtil;
import com.jxdinfo.liteflow.exception.WhenTimeoutException;
import com.jxdinfo.liteflow.flow.element.Chain;
import com.jxdinfo.liteflow.flow.element.Condition;
import com.jxdinfo.liteflow.flow.element.Executable;
import com.jxdinfo.liteflow.flow.element.Node;
import com.jxdinfo.liteflow.flow.element.condition.WhenCondition;
import java.util.concurrent.TimeoutException;

public class TimeoutCondition
extends WhenCondition {
    @Override
    public void executeCondition(Integer slotIndex) throws Exception {
        try {
            super.executeCondition(slotIndex);
        }
        catch (WhenTimeoutException ex) {
            String errMsg = StrFormatter.format("Timed out when executing the chain [{}] because [{}] exceeded {} {}.", this.getCurrChainId(), this.getCurrentExecutableId(), this.getMaxWaitTime(), this.getMaxWaitTimeUnit().toString().toLowerCase());
            throw new TimeoutException(errMsg);
        }
    }

    private String getCurrentExecutableId() {
        Executable executable = this.getExecutableList().get(0);
        if (ObjectUtil.isNotNull(executable.getId())) {
            return executable.getId();
        }
        switch (executable.getExecuteType()) {
            case CHAIN: {
                return ((Chain)executable).getChainId();
            }
            case CONDITION: {
                return "condition-" + ((Condition)executable).getConditionType().getName();
            }
            case NODE: {
                return "node-" + ((Node)executable).getType().getCode();
            }
        }
        return "unknown-executable";
    }
}

