/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.liteflow.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class LimitQueue<E>
implements Queue<E> {
    private final int limit;
    Queue<E> queue = new ConcurrentLinkedQueue();

    public LimitQueue(int limit) {
        this.limit = limit;
    }

    @Override
    public boolean offer(E e) {
        if (this.queue.size() >= this.limit) {
            this.queue.poll();
        }
        return this.queue.offer(e);
    }

    @Override
    public E poll() {
        return this.queue.poll();
    }

    public Queue<E> getQueue() {
        return this.queue;
    }

    public int getLimit() {
        return this.limit;
    }

    @Override
    public boolean add(E e) {
        return this.queue.add(e);
    }

    @Override
    public E element() {
        return this.queue.element();
    }

    @Override
    public E peek() {
        return this.queue.peek();
    }

    @Override
    public boolean isEmpty() {
        return this.queue.size() == 0;
    }

    @Override
    public int size() {
        return this.queue.size();
    }

    @Override
    public E remove() {
        return this.queue.remove();
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        return this.queue.addAll(c);
    }

    @Override
    public void clear() {
        this.queue.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.queue.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.queue.containsAll(c);
    }

    @Override
    public Iterator<E> iterator() {
        return this.queue.iterator();
    }

    @Override
    public boolean remove(Object o) {
        return this.queue.remove(o);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.queue.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.queue.retainAll(c);
    }

    @Override
    public Object[] toArray() {
        return this.queue.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.queue.toArray(a);
    }
}

