/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hutool.core.annotation;

import com.jxdinfo.hutool.core.annotation.AnnotationAttribute;
import com.jxdinfo.hutool.core.annotation.AnnotationSynthesizer;
import com.jxdinfo.hutool.core.annotation.AnnotationUtil;
import com.jxdinfo.hutool.core.annotation.Link;
import com.jxdinfo.hutool.core.annotation.RelationType;
import com.jxdinfo.hutool.core.annotation.SynthesizedAnnotation;
import com.jxdinfo.hutool.core.annotation.SynthesizedAnnotationPostProcessor;
import com.jxdinfo.hutool.core.lang.Assert;
import com.jxdinfo.hutool.core.lang.Opt;
import com.jxdinfo.hutool.core.util.ArrayUtil;
import com.jxdinfo.hutool.core.util.ObjectUtil;
import java.lang.annotation.Annotation;
import java.util.HashMap;

public abstract class AbstractLinkAnnotationPostProcessor
implements SynthesizedAnnotationPostProcessor {
    @Override
    public void process(SynthesizedAnnotation synthesizedAnnotation, AnnotationSynthesizer synthesizer) {
        HashMap<String, AnnotationAttribute> attributeMap = new HashMap<String, AnnotationAttribute>(synthesizedAnnotation.getAttributes());
        attributeMap.forEach((originalAttributeName, originalAttribute) -> {
            Link link = this.getLinkAnnotation((AnnotationAttribute)originalAttribute, this.processTypes());
            if (ObjectUtil.isNull(link)) {
                return;
            }
            SynthesizedAnnotation linkedAnnotation = this.getLinkedAnnotation(link, synthesizer, synthesizedAnnotation.annotationType());
            if (ObjectUtil.isNull(linkedAnnotation)) {
                return;
            }
            AnnotationAttribute linkedAttribute = linkedAnnotation.getAttributes().get(link.attribute());
            this.processLinkedAttribute(synthesizer, link, synthesizedAnnotation, synthesizedAnnotation.getAttributes().get(originalAttributeName), linkedAnnotation, linkedAttribute);
        });
    }

    protected abstract RelationType[] processTypes();

    protected abstract void processLinkedAttribute(AnnotationSynthesizer var1, Link var2, SynthesizedAnnotation var3, AnnotationAttribute var4, SynthesizedAnnotation var5, AnnotationAttribute var6);

    protected Link getLinkAnnotation(AnnotationAttribute attribute, RelationType ... relationTypes) {
        return Opt.ofNullable(attribute).map(t -> AnnotationUtil.getSynthesizedAnnotation(attribute.getAttribute(), Link.class)).filter(a -> ArrayUtil.contains(relationTypes, a.type())).get();
    }

    protected SynthesizedAnnotation getLinkedAnnotation(Link annotation, AnnotationSynthesizer synthesizer, Class<? extends Annotation> defaultType) {
        Class<?> targetAnnotationType = this.getLinkedAnnotationType(annotation, defaultType);
        return synthesizer.getSynthesizedAnnotation(targetAnnotationType);
    }

    protected Class<?> getLinkedAnnotationType(Link annotation, Class<?> defaultType) {
        return ObjectUtil.equals(annotation.annotation(), Annotation.class) ? defaultType : annotation.annotation();
    }

    protected void checkAttributeType(AnnotationAttribute original, AnnotationAttribute alias) {
        Assert.equals(original.getAttributeType(), alias.getAttributeType(), "return type of the linked attribute [{}] is inconsistent with the original [{}]", original.getAttribute(), alias.getAttribute());
    }

    protected void checkLinkedSelf(AnnotationAttribute original, AnnotationAttribute linked) {
        boolean linkSelf = original == linked || ObjectUtil.equals(original.getAttribute(), linked.getAttribute());
        Assert.isFalse(linkSelf, "cannot link self [{}]", original.getAttribute());
    }

    protected void checkLinkedAttributeNotNull(AnnotationAttribute original, AnnotationAttribute linkedAttribute, Link annotation) {
        Assert.notNull(linkedAttribute, "cannot find linked attribute [{}] of original [{}] in [{}]", original.getAttribute(), annotation.attribute(), this.getLinkedAnnotationType(annotation, original.getAnnotationType()));
    }
}

