/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hutool.core.annotation;

import com.jxdinfo.hutool.core.annotation.AnnotationSynthesizer;
import com.jxdinfo.hutool.core.annotation.SynthesizedAnnotation;
import com.jxdinfo.hutool.core.annotation.SynthesizedAnnotationPostProcessor;
import com.jxdinfo.hutool.core.annotation.SynthesizedAnnotationSelector;
import com.jxdinfo.hutool.core.annotation.scanner.AnnotationScanner;
import com.jxdinfo.hutool.core.collection.CollUtil;
import com.jxdinfo.hutool.core.lang.Assert;
import com.jxdinfo.hutool.core.map.MapUtil;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public abstract class AbstractAnnotationSynthesizer<T>
implements AnnotationSynthesizer {
    protected final T source;
    protected final Map<Class<? extends Annotation>, SynthesizedAnnotation> synthesizedAnnotationMap;
    private final Map<Class<? extends Annotation>, Annotation> synthesizedProxyAnnotations;
    protected final SynthesizedAnnotationSelector annotationSelector;
    protected final Collection<SynthesizedAnnotationPostProcessor> postProcessors;
    protected final AnnotationScanner annotationScanner;

    protected AbstractAnnotationSynthesizer(T source, SynthesizedAnnotationSelector annotationSelector, Collection<SynthesizedAnnotationPostProcessor> annotationPostProcessors, AnnotationScanner annotationScanner) {
        Assert.notNull(source, "source must not null", new Object[0]);
        Assert.notNull(annotationSelector, "annotationSelector must not null", new Object[0]);
        Assert.notNull(annotationPostProcessors, "annotationPostProcessors must not null", new Object[0]);
        Assert.notNull(annotationPostProcessors, "annotationScanner must not null", new Object[0]);
        this.source = source;
        this.annotationSelector = annotationSelector;
        this.annotationScanner = annotationScanner;
        this.postProcessors = CollUtil.unmodifiable(CollUtil.sort(annotationPostProcessors, Comparator.comparing(SynthesizedAnnotationPostProcessor::order)));
        this.synthesizedProxyAnnotations = new LinkedHashMap<Class<? extends Annotation>, Annotation>();
        this.synthesizedAnnotationMap = MapUtil.unmodifiable(this.loadAnnotations());
        annotationPostProcessors.forEach(processor -> this.synthesizedAnnotationMap.values().forEach(synthesized -> processor.process((SynthesizedAnnotation)synthesized, this)));
    }

    protected abstract Map<Class<? extends Annotation>, SynthesizedAnnotation> loadAnnotations();

    protected abstract <A extends Annotation> A synthesize(Class<A> var1, SynthesizedAnnotation var2);

    public T getSource() {
        return this.source;
    }

    @Override
    public SynthesizedAnnotationSelector getAnnotationSelector() {
        return this.annotationSelector;
    }

    @Override
    public Collection<SynthesizedAnnotationPostProcessor> getAnnotationPostProcessors() {
        return this.postProcessors;
    }

    @Override
    public SynthesizedAnnotation getSynthesizedAnnotation(Class<?> annotationType) {
        return this.synthesizedAnnotationMap.get(annotationType);
    }

    @Override
    public Map<Class<? extends Annotation>, SynthesizedAnnotation> getAllSynthesizedAnnotation() {
        return this.synthesizedAnnotationMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <A extends Annotation> A synthesize(Class<A> annotationType) {
        Annotation annotation = this.synthesizedProxyAnnotations.get(annotationType);
        if (Objects.nonNull(annotation)) {
            return (A)annotation;
        }
        Map<Class<? extends Annotation>, Annotation> map = this.synthesizedProxyAnnotations;
        synchronized (map) {
            annotation = this.synthesizedProxyAnnotations.get(annotationType);
            if (Objects.isNull(annotation)) {
                SynthesizedAnnotation synthesizedAnnotation = this.synthesizedAnnotationMap.get(annotationType);
                annotation = this.synthesize(annotationType, synthesizedAnnotation);
                this.synthesizedProxyAnnotations.put(annotationType, annotation);
            }
        }
        return (A)annotation;
    }
}

