/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.liteflow.monitor;

import com.jxdinfo.hutool.core.util.BooleanUtil;
import com.jxdinfo.liteflow.monitor.CompStatistics;
import com.jxdinfo.liteflow.monitor.MonitorTimeTask;
import com.jxdinfo.liteflow.property.LiteflowConfig;
import com.jxdinfo.liteflow.slot.DataBus;
import com.jxdinfo.liteflow.util.BoundedPriorityBlockingQueue;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonitorBus {
    private LiteflowConfig liteflowConfig;
    private final Logger LOG = LoggerFactory.getLogger(this.getClass());
    private final ConcurrentHashMap<String, BoundedPriorityBlockingQueue<CompStatistics>> statisticsMap = new ConcurrentHashMap();
    private final ScheduledExecutorService printLogScheduler = Executors.newScheduledThreadPool(1);

    public MonitorBus(LiteflowConfig liteflowConfig) {
        this.liteflowConfig = liteflowConfig;
        if (BooleanUtil.isTrue(liteflowConfig.getEnableLog())) {
            this.printLogScheduler.scheduleAtFixedRate(new MonitorTimeTask(this), liteflowConfig.getDelay(), liteflowConfig.getPeriod(), TimeUnit.MILLISECONDS);
        }
    }

    public void addStatistics(CompStatistics statistics) {
        if (this.statisticsMap.containsKey(statistics.getComponentClazzName())) {
            this.statisticsMap.get(statistics.getComponentClazzName()).add(statistics);
        } else {
            BoundedPriorityBlockingQueue<CompStatistics> queue = new BoundedPriorityBlockingQueue<CompStatistics>(this.liteflowConfig.getQueueLimit());
            queue.offer(statistics);
            this.statisticsMap.put(statistics.getComponentClazzName(), queue);
        }
    }

    public void printStatistics() {
        try {
            HashMap<String, BigDecimal> compAverageTimeSpent = new HashMap<String, BigDecimal>();
            for (Map.Entry<String, BoundedPriorityBlockingQueue<CompStatistics>> entry : this.statisticsMap.entrySet()) {
                long totalTimeSpent = 0L;
                for (CompStatistics statistics : entry.getValue()) {
                    totalTimeSpent += statistics.getTimeSpent();
                }
                compAverageTimeSpent.put(entry.getKey(), new BigDecimal(totalTimeSpent).divide(new BigDecimal(entry.getValue().size()), 2, RoundingMode.HALF_UP));
            }
            ArrayList compAverageTimeSpentEntryList = new ArrayList(compAverageTimeSpent.entrySet());
            Collections.sort(compAverageTimeSpentEntryList, (o1, o2) -> ((BigDecimal)o2.getValue()).compareTo((BigDecimal)o1.getValue()));
            StringBuilder logStr = new StringBuilder();
            logStr.append("\u4ee5\u4e0b\u4e3aLiteFlow\u4e2d\u95f4\u4ef6\u7edf\u8ba1\u4fe1\u606f\uff1a\n");
            logStr.append("======================================================================================\n");
            logStr.append("===================================SLOT INFO==========================================\n");
            logStr.append(MessageFormat.format("SLOT TOTAL SIZE : {0}\n", this.liteflowConfig.getSlotSize()));
            logStr.append(MessageFormat.format("SLOT OCCUPY COUNT : {0}\n", DataBus.OCCUPY_COUNT));
            logStr.append("===============================TIME AVERAGE SPENT=====================================\n");
            for (Map.Entry entry : compAverageTimeSpentEntryList) {
                logStr.append(MessageFormat.format("COMPONENT[{0}] AVERAGE TIME SPENT : {1}\n", entry.getKey(), entry.getValue()));
            }
            logStr.append("======================================================================================\n");
            this.LOG.info(logStr.toString());
        }
        catch (Exception e) {
            this.LOG.error("print statistics cause error", (Throwable)e);
        }
    }

    public LiteflowConfig getLiteflowConfig() {
        return this.liteflowConfig;
    }

    public void setLiteflowConfig(LiteflowConfig liteflowConfig) {
        this.liteflowConfig = liteflowConfig;
    }

    public void closeScheduler() {
        this.printLogScheduler.shutdown();
    }

    public ConcurrentHashMap<String, BoundedPriorityBlockingQueue<CompStatistics>> getStatisticsMap() {
        return this.statisticsMap;
    }
}

