/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.liteflow.flow.id;

import com.jxdinfo.hutool.core.util.ObjectUtil;
import com.jxdinfo.hutool.core.util.StrUtil;
import com.jxdinfo.liteflow.exception.RequestIdGeneratorException;
import com.jxdinfo.liteflow.flow.id.DefaultRequestIdGenerator;
import com.jxdinfo.liteflow.flow.id.RequestIdGenerator;
import com.jxdinfo.liteflow.property.LiteflowConfig;
import com.jxdinfo.liteflow.property.LiteflowConfigGetter;
import com.jxdinfo.liteflow.spi.holder.ContextAwareHolder;

public class IdGeneratorHolder {
    private RequestIdGenerator requestIdGenerator;
    private static final IdGeneratorHolder INSTANCE = new IdGeneratorHolder();

    public static void init() {
        try {
            RequestIdGenerator requestIdGenerator;
            LiteflowConfig liteflowConfig = LiteflowConfigGetter.get();
            String requestIdGeneratorClass = liteflowConfig.getRequestIdGeneratorClass();
            if (StrUtil.isBlank(requestIdGeneratorClass)) {
                requestIdGenerator = new DefaultRequestIdGenerator();
            } else {
                Class<?> idGenerateClass = Class.forName(requestIdGeneratorClass);
                requestIdGenerator = (RequestIdGenerator)ContextAwareHolder.loadContextAware().registerBean(idGenerateClass);
            }
            INSTANCE.setRequestIdGenerator(requestIdGenerator);
        }
        catch (Exception e) {
            throw new RequestIdGeneratorException(e.getMessage());
        }
    }

    public static IdGeneratorHolder getInstance() {
        return INSTANCE;
    }

    public String generate() {
        if (ObjectUtil.isNull(this.requestIdGenerator)) {
            IdGeneratorHolder.init();
        }
        return this.requestIdGenerator.generate();
    }

    public RequestIdGenerator getRequestIdGenerator() {
        return this.requestIdGenerator;
    }

    public void setRequestIdGenerator(RequestIdGenerator requestIdGenerator) {
        this.requestIdGenerator = requestIdGenerator;
    }
}

