/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.liteflow.flow.element.condition;

import com.jxdinfo.hutool.core.util.StrUtil;
import com.jxdinfo.liteflow.enums.ConditionTypeEnum;
import com.jxdinfo.liteflow.flow.element.Condition;
import com.jxdinfo.liteflow.flow.element.Executable;
import com.jxdinfo.liteflow.log.LFLog;
import com.jxdinfo.liteflow.log.LFLoggerManager;
import com.jxdinfo.liteflow.slot.DataBus;
import com.jxdinfo.liteflow.slot.Slot;

public class NotCondition
extends Condition {
    private final LFLog LOG = LFLoggerManager.getLogger(this.getClass());

    @Override
    public void executeCondition(Integer slotIndex) throws Exception {
        Executable item = this.getItem();
        item.setCurrChainId(this.getCurrChainId());
        item.execute(slotIndex);
        boolean flag = (Boolean)item.getItemResultMetaValue(slotIndex);
        this.LOG.info("the result of boolean component [{}] is [{}]", (Object)item.getId(), (Object)flag);
        Slot slot = DataBus.getSlot(slotIndex);
        String resultKey = StrUtil.format("{}_{}", this.getClass().getName(), this.hashCode());
        slot.setNotResult(resultKey, !flag);
    }

    public Boolean getItemResultMetaValue(Integer slotIndex) {
        Slot slot = DataBus.getSlot(slotIndex);
        String resultKey = StrUtil.format("{}_{}", this.getClass().getName(), this.hashCode());
        return slot.getNotResult(resultKey);
    }

    @Override
    public ConditionTypeEnum getConditionType() {
        return ConditionTypeEnum.TYPE_NOT_OPT;
    }

    public void setItem(Executable item) {
        this.addExecutable("NOT_ITEM_KEY", item);
    }

    public Executable getItem() {
        return this.getExecutableOne("NOT_ITEM_KEY");
    }
}

