/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hutool.core.map;

import com.jxdinfo.hutool.core.builder.Builder;
import com.jxdinfo.hutool.core.map.MapUtil;
import java.util.Map;
import java.util.function.Supplier;

public class MapBuilder<K, V>
implements Builder<Map<K, V>> {
    private static final long serialVersionUID = 1L;
    private final Map<K, V> map;

    public static <K, V> MapBuilder<K, V> create() {
        return MapBuilder.create(false);
    }

    public static <K, V> MapBuilder<K, V> create(boolean isLinked) {
        return MapBuilder.create(MapUtil.newHashMap(isLinked));
    }

    public static <K, V> MapBuilder<K, V> create(Map<K, V> map) {
        return new MapBuilder<K, V>(map);
    }

    public MapBuilder(Map<K, V> map) {
        this.map = map;
    }

    public MapBuilder<K, V> put(K k, V v) {
        this.map.put(k, v);
        return this;
    }

    public MapBuilder<K, V> put(boolean condition, K k, V v) {
        if (condition) {
            this.put(k, v);
        }
        return this;
    }

    public MapBuilder<K, V> put(boolean condition, K k, Supplier<V> supplier) {
        if (condition) {
            this.put(k, supplier.get());
        }
        return this;
    }

    public MapBuilder<K, V> putAll(Map<K, V> map) {
        this.map.putAll(map);
        return this;
    }

    public MapBuilder<K, V> clear() {
        this.map.clear();
        return this;
    }

    public Map<K, V> map() {
        return this.map;
    }

    @Override
    public Map<K, V> build() {
        return this.map();
    }
}

