/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hutool.core.io;

import com.jxdinfo.hutool.core.io.IORuntimeException;
import com.jxdinfo.hutool.core.lang.Assert;
import com.jxdinfo.hutool.core.util.CharsetUtil;
import com.jxdinfo.hutool.core.util.StrUtil;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;

public class NioUtil {
    public static final int DEFAULT_BUFFER_SIZE = 8192;
    public static final int DEFAULT_MIDDLE_BUFFER_SIZE = 16384;
    public static final int DEFAULT_LARGE_BUFFER_SIZE = 32768;
    public static final int EOF = -1;

    public static long copy(FileChannel inChannel, FileChannel outChannel) throws IORuntimeException {
        Assert.notNull(inChannel, "In channel is null!", new Object[0]);
        Assert.notNull(outChannel, "Out channel is null!", new Object[0]);
        try {
            return NioUtil.copySafely(inChannel, outChannel);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    private static long copySafely(FileChannel inChannel, FileChannel outChannel) throws IOException {
        long writeBytes;
        long totalBytes = inChannel.size();
        long pos = 0L;
        for (long remaining = totalBytes; remaining > 0L; remaining -= writeBytes) {
            writeBytes = inChannel.transferTo(pos, remaining, outChannel);
            pos += writeBytes;
        }
        return totalBytes;
    }

    public static String readUtf8(FileChannel fileChannel) throws IORuntimeException {
        return NioUtil.read(fileChannel, CharsetUtil.CHARSET_UTF_8);
    }

    public static String read(FileChannel fileChannel, String charsetName) throws IORuntimeException {
        return NioUtil.read(fileChannel, CharsetUtil.charset(charsetName));
    }

    public static String read(FileChannel fileChannel, Charset charset) throws IORuntimeException {
        MappedByteBuffer buffer;
        try {
            buffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, fileChannel.size()).load();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        return StrUtil.str((ByteBuffer)buffer, charset);
    }

    public static void close(AutoCloseable closeable) {
        if (null != closeable) {
            try {
                closeable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

