/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hutool.core.bean.copier;

import com.jxdinfo.hutool.core.bean.BeanUtil;
import com.jxdinfo.hutool.core.bean.PropDesc;
import com.jxdinfo.hutool.core.bean.copier.AbsCopier;
import com.jxdinfo.hutool.core.bean.copier.CopyOptions;
import com.jxdinfo.hutool.core.bean.copier.ValueProvider;
import com.jxdinfo.hutool.core.lang.Assert;
import com.jxdinfo.hutool.core.util.TypeUtil;
import java.lang.reflect.Type;
import java.util.Map;

public class ValueProviderToBeanCopier<T>
extends AbsCopier<ValueProvider<String>, T> {
    private final Type targetType;

    public ValueProviderToBeanCopier(ValueProvider<String> source, T target, Type targetType, CopyOptions copyOptions) {
        super(source, target, copyOptions);
        this.targetType = targetType;
    }

    @Override
    public T copy() {
        Class<?> actualEditable = this.target.getClass();
        if (null != this.copyOptions.editable) {
            Assert.isTrue(this.copyOptions.editable.isInstance(this.target), "Target class [{}] not assignable to Editable class [{}]", actualEditable.getName(), this.copyOptions.editable.getName());
            actualEditable = this.copyOptions.editable;
        }
        Map<String, PropDesc> targetPropDescMap = BeanUtil.getBeanDesc(actualEditable).getPropMap(this.copyOptions.ignoreCase);
        targetPropDescMap.forEach((tFieldName, tDesc) -> {
            if (null == tFieldName) {
                return;
            }
            if (null == (tFieldName = this.copyOptions.editFieldName((String)tFieldName))) {
                return;
            }
            if (!((ValueProvider)this.source).containsKey(tFieldName)) {
                return;
            }
            if (!this.copyOptions.testKeyFilter(tFieldName)) {
                return;
            }
            if (null == tDesc || !tDesc.isWritable(this.copyOptions.transientSupport)) {
                return;
            }
            Type fieldType = TypeUtil.getActualType(this.targetType, tDesc.getFieldType());
            Object sValue = ((ValueProvider)this.source).value(tFieldName, fieldType);
            if (!this.copyOptions.testPropertyFilter(tDesc.getField(), sValue)) {
                return;
            }
            sValue = this.copyOptions.editFieldValue((String)tFieldName, sValue);
            tDesc.setValue(this.target, sValue, this.copyOptions.ignoreNullValue, this.copyOptions.ignoreError, this.copyOptions.override);
        });
        return (T)this.target;
    }
}

