/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hutool.core.annotation;

import com.jxdinfo.hutool.core.annotation.Hierarchical;
import com.jxdinfo.hutool.core.annotation.SynthesizedAnnotation;
import com.jxdinfo.hutool.core.annotation.SynthesizedAnnotationAttributeProcessor;
import com.jxdinfo.hutool.core.lang.Assert;
import com.jxdinfo.hutool.core.map.multi.RowKeyTable;
import com.jxdinfo.hutool.core.map.multi.Table;
import java.util.Collection;
import java.util.Comparator;
import java.util.Objects;

public class CacheableSynthesizedAnnotationAttributeProcessor
implements SynthesizedAnnotationAttributeProcessor {
    private final Table<String, Class<?>, Object> valueCaches = new RowKeyTable();
    private final Comparator<Hierarchical> annotationComparator;

    public CacheableSynthesizedAnnotationAttributeProcessor(Comparator<Hierarchical> annotationComparator) {
        Assert.notNull(annotationComparator, "annotationComparator must not null", new Object[0]);
        this.annotationComparator = annotationComparator;
    }

    public CacheableSynthesizedAnnotationAttributeProcessor() {
        this(Hierarchical.DEFAULT_HIERARCHICAL_COMPARATOR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getAttributeValue(String attributeName, Class<T> attributeType, Collection<? extends SynthesizedAnnotation> synthesizedAnnotations) {
        Object value = this.valueCaches.get(attributeName, attributeType);
        if (Objects.isNull(value)) {
            Table<String, Class<?>, Object> table = this.valueCaches;
            synchronized (table) {
                value = this.valueCaches.get(attributeName, attributeType);
                if (Objects.isNull(value)) {
                    value = synthesizedAnnotations.stream().filter(ma -> ma.hasAttribute(attributeName, attributeType)).min(this.annotationComparator).map(ma -> ma.getAttributeValue(attributeName)).orElse(null);
                    this.valueCaches.put(attributeName, attributeType, value);
                }
            }
        }
        return (T)value;
    }
}

