/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hutool.core.annotation;

import com.jxdinfo.hutool.core.annotation.Alias;
import com.jxdinfo.hutool.core.annotation.AnnotationAttribute;
import com.jxdinfo.hutool.core.annotation.AnnotationSynthesizer;
import com.jxdinfo.hutool.core.annotation.ForceAliasedAnnotationAttribute;
import com.jxdinfo.hutool.core.annotation.SynthesizedAnnotation;
import com.jxdinfo.hutool.core.annotation.SynthesizedAnnotationPostProcessor;
import com.jxdinfo.hutool.core.lang.Assert;
import com.jxdinfo.hutool.core.lang.Opt;
import com.jxdinfo.hutool.core.map.LinkedForestMap;
import com.jxdinfo.hutool.core.util.ClassUtil;
import com.jxdinfo.hutool.core.util.ObjectUtil;
import java.util.Map;

public class AliasAnnotationPostProcessor
implements SynthesizedAnnotationPostProcessor {
    @Override
    public int order() {
        return Integer.MIN_VALUE;
    }

    @Override
    public void process(SynthesizedAnnotation synthesizedAnnotation, AnnotationSynthesizer synthesizer) {
        Map<String, AnnotationAttribute> attributeMap = synthesizedAnnotation.getAttributes();
        LinkedForestMap attributeAliasMappings = new LinkedForestMap(false);
        attributeMap.forEach((attributeName, attribute) -> {
            String alias = Opt.ofNullable(attribute.getAnnotation(Alias.class)).map(Alias::value).orElse(null);
            if (ObjectUtil.isNull(alias)) {
                return;
            }
            AnnotationAttribute aliasAttribute = (AnnotationAttribute)attributeMap.get(alias);
            Assert.notNull(aliasAttribute, "no method for alias: [{}]", alias);
            attributeAliasMappings.putLinkedNodes(alias, aliasAttribute, attributeName, attribute);
        });
        attributeMap.forEach((attributeName, attribute) -> {
            AnnotationAttribute resolvedAttribute = Opt.ofNullable(attributeName).map(attributeAliasMappings::getRootNode).map(Map.Entry::getValue).orElse((AnnotationAttribute)attribute);
            Assert.isTrue(ObjectUtil.isNull(resolvedAttribute) || ClassUtil.isAssignable(attribute.getAttributeType(), resolvedAttribute.getAttributeType()), "return type of the root alias method [{}] is inconsistent with the original [{}]", resolvedAttribute.getClass(), attribute.getAttributeType());
            if (attribute != resolvedAttribute) {
                attributeMap.put((String)attributeName, new ForceAliasedAnnotationAttribute((AnnotationAttribute)attribute, resolvedAttribute));
            }
        });
        synthesizedAnnotation.setAttributes(attributeMap);
    }
}

