/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hutool.core.util;

import com.jxdinfo.hutool.core.collection.CollUtil;
import com.jxdinfo.hutool.core.util.ArrayUtil;
import com.jxdinfo.hutool.core.util.StrUtil;
import java.util.Set;

public class BooleanUtil {
    private static final Set<String> TRUE_SET = CollUtil.newHashSet("true", "yes", "y", "t", "ok", "1", "on", "\u662f", "\u5bf9", "\u771f", "\u5c0d", "\u221a");
    private static final Set<String> FALSE_SET = CollUtil.newHashSet("false", "no", "n", "f", "0", "off", "\u5426", "\u9519", "\u5047", "\u932f", "\u00d7");

    public static boolean isTrue(Boolean bool) {
        return Boolean.TRUE.equals(bool);
    }

    public static boolean isFalse(Boolean bool) {
        return Boolean.FALSE.equals(bool);
    }

    public static boolean toBoolean(String valueStr) {
        if (StrUtil.isNotBlank(valueStr)) {
            valueStr = valueStr.trim().toLowerCase();
            return TRUE_SET.contains(valueStr);
        }
        return false;
    }

    public static int toInt(boolean value) {
        return value ? 1 : 0;
    }

    public static Integer toInteger(boolean value) {
        return BooleanUtil.toInt(value);
    }

    public static char toChar(boolean value) {
        return (char)BooleanUtil.toInt(value);
    }

    public static Character toCharacter(boolean value) {
        return Character.valueOf(BooleanUtil.toChar(value));
    }

    public static byte toByte(boolean value) {
        return (byte)BooleanUtil.toInt(value);
    }

    public static Byte toByteObj(boolean value) {
        return BooleanUtil.toByte(value);
    }

    public static long toLong(boolean value) {
        return BooleanUtil.toInt(value);
    }

    public static Long toLongObj(boolean value) {
        return BooleanUtil.toLong(value);
    }

    public static short toShort(boolean value) {
        return (short)BooleanUtil.toInt(value);
    }

    public static Short toShortObj(boolean value) {
        return BooleanUtil.toShort(value);
    }

    public static float toFloat(boolean value) {
        return BooleanUtil.toInt(value);
    }

    public static Float toFloatObj(boolean value) {
        return Float.valueOf(BooleanUtil.toFloat(value));
    }

    public static double toDouble(boolean value) {
        return BooleanUtil.toInt(value);
    }

    public static Double toDoubleObj(boolean value) {
        return BooleanUtil.toDouble(value);
    }

    public static String toString(boolean bool, String trueString, String falseString) {
        return bool ? trueString : falseString;
    }

    public static boolean xor(boolean ... array) {
        if (ArrayUtil.isEmpty(array)) {
            throw new IllegalArgumentException("The Array must not be empty");
        }
        boolean result = false;
        for (boolean element : array) {
            result ^= element;
        }
        return result;
    }

    public static boolean isBoolean(Class<?> clazz) {
        return clazz == Boolean.class || clazz == Boolean.TYPE;
    }
}

