/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hutool.core.io.resource;

import com.jxdinfo.hutool.core.collection.EnumerationIter;
import com.jxdinfo.hutool.core.io.IORuntimeException;
import com.jxdinfo.hutool.core.util.ClassLoaderUtil;
import com.jxdinfo.hutool.core.util.ObjUtil;
import com.jxdinfo.hutool.core.util.StrUtil;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;

public class ResourceUtil {
    public static URL getResource(String resource) throws IORuntimeException {
        return ResourceUtil.getResource(resource, null);
    }

    public static EnumerationIter<URL> getResourceIter(String resource, ClassLoader classLoader) {
        Enumeration<URL> resources;
        try {
            resources = ObjUtil.defaultIfNull(classLoader, ClassLoaderUtil::getClassLoader).getResources(resource);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        return new EnumerationIter<URL>(resources);
    }

    public static URL getResource(String resource, Class<?> baseClass) {
        resource = StrUtil.nullToEmpty(resource);
        return null != baseClass ? baseClass.getResource(resource) : ClassLoaderUtil.getClassLoader().getResource(resource);
    }
}

