/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.liteflow.script.validator;

import com.jxdinfo.hutool.core.util.StrUtil;
import com.jxdinfo.liteflow.enums.ScriptTypeEnum;
import com.jxdinfo.liteflow.log.LFLog;
import com.jxdinfo.liteflow.log.LFLoggerManager;
import com.jxdinfo.liteflow.script.ScriptExecutor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;

public class ScriptValidator {
    private static final LFLog LOG = LFLoggerManager.getLogger(ScriptValidator.class);
    private static final Map<ScriptTypeEnum, ScriptExecutor> scriptExecutors;

    private static boolean validateScript(String script, ScriptTypeEnum scriptType) {
        if (scriptExecutors.isEmpty()) {
            LOG.error("The loaded script modules not found.");
            return false;
        }
        if (scriptType != null && !scriptExecutors.containsKey((Object)scriptType)) {
            LOG.error(StrUtil.format("Specified script language {} was not found.", new Object[]{scriptType}));
            return false;
        }
        if (scriptExecutors.size() > 1 && scriptType == null) {
            LOG.error("The loaded script modules more than 1. Please specify the script language.");
            return false;
        }
        ScriptExecutor scriptExecutor = scriptType != null ? scriptExecutors.get((Object)scriptType) : scriptExecutors.values().iterator().next();
        try {
            scriptExecutor.compile(script);
        }
        catch (Exception e) {
            LOG.error(StrUtil.format("{} Script component validate failure. ", new Object[]{scriptExecutor.scriptType()}) + e.getMessage());
            return false;
        }
        return true;
    }

    public static boolean validate(String script) {
        return ScriptValidator.validateScript(script, null);
    }

    public static boolean validate(String script, ScriptTypeEnum scriptType) {
        return ScriptValidator.validateScript(script, scriptType);
    }

    public static boolean validate(Map<ScriptTypeEnum, String> scripts) {
        for (Map.Entry<ScriptTypeEnum, String> script : scripts.entrySet()) {
            if (ScriptValidator.validate(script.getValue(), script.getKey())) continue;
            return false;
        }
        return true;
    }

    static {
        ArrayList scriptExecutorList = new ArrayList();
        scriptExecutors = new HashMap<ScriptTypeEnum, ScriptExecutor>();
        ServiceLoader.load(ScriptExecutor.class).forEach(scriptExecutorList::add);
        scriptExecutorList.stream().peek(ScriptExecutor::init).forEach(scriptExecutor -> scriptExecutors.put(scriptExecutor.scriptType(), (ScriptExecutor)scriptExecutor));
    }
}

