/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.liteflow.core.proxy;

import com.jxdinfo.hutool.core.exceptions.InvocationTargetRuntimeException;
import com.jxdinfo.hutool.core.util.ArrayUtil;
import com.jxdinfo.hutool.core.util.ReflectUtil;
import com.jxdinfo.hutool.core.util.StrUtil;
import com.jxdinfo.liteflow.annotation.LiteflowMethod;
import com.jxdinfo.liteflow.annotation.LiteflowRetry;
import com.jxdinfo.liteflow.core.NodeComponent;
import com.jxdinfo.liteflow.core.proxy.DeclWarpBean;
import com.jxdinfo.liteflow.core.proxy.MethodWrapBean;
import com.jxdinfo.liteflow.core.proxy.ParameterWrapBean;
import com.jxdinfo.liteflow.exception.ComponentMethodDefineErrorException;
import com.jxdinfo.liteflow.exception.LiteFlowException;
import com.jxdinfo.liteflow.exception.ProxyException;
import com.jxdinfo.liteflow.log.LFLog;
import com.jxdinfo.liteflow.log.LFLoggerManager;
import com.jxdinfo.liteflow.slot.DataBus;
import com.jxdinfo.liteflow.util.SerialsUtil;
import com.ql.util.express.DefaultContext;
import com.ql.util.express.ExpressRunner;
import com.ql.util.express.IExpressContext;
import com.ql.util.express.InstructionSet;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.InvocationHandlerAdapter;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public class DeclComponentProxy {
    private final LFLog LOG = LFLoggerManager.getLogger(this.getClass());
    private final DeclWarpBean declWarpBean;
    private final ExpressRunner expressRunner = new ExpressRunner();

    public DeclComponentProxy(DeclWarpBean declWarpBean) {
        this.declWarpBean = declWarpBean;
    }

    public NodeComponent getProxy() throws Exception {
        boolean legal;
        Annotation[] beanClassAnnotation = this.declWarpBean.getRawClazz().getAnnotations();
        List classes = this.declWarpBean.getMethodWrapBeanList().stream().map(methodWrapBean -> methodWrapBean.getLiteflowMethod().nodeType().getMappingClazz()).distinct().collect(Collectors.toList());
        boolean bl = legal = classes.size() == 1;
        if (!legal) {
            throw new LiteFlowException("The cmpClass of the same nodeId must be the same,you declared nodeId:" + this.declWarpBean.getNodeId() + ",cmpClass:" + this.declWarpBean.getRawClazz());
        }
        LiteflowRetry liteflowRetry = this.declWarpBean.getMethodWrapBeanList().stream().filter(methodWrapBean -> {
            LiteflowRetry lfr = methodWrapBean.getLiteflowRetry();
            LiteflowMethod lfm = methodWrapBean.getLiteflowMethod();
            return lfr != null && lfm.value().isMainMethod();
        }).map(MethodWrapBean::getLiteflowRetry).findFirst().orElse(null);
        if (liteflowRetry != null) {
            beanClassAnnotation = ArrayUtil.append(beanClassAnnotation, new Annotation[]{liteflowRetry});
        }
        try {
            Object instance = new ByteBuddy().subclass(this.declWarpBean.getNodeType().getMappingClazz()).name(StrUtil.format("{}$ByteBuddy${}${}", this.declWarpBean.getRawClazz().getName(), this.declWarpBean.getNodeId(), SerialsUtil.generateShortUUID())).implement((Type[])this.declWarpBean.getRawClazz().getInterfaces()).method((ElementMatcher)ElementMatchers.namedOneOf((String[])((String[])this.declWarpBean.getMethodWrapBeanList().stream().map(wrap -> wrap.getLiteflowMethod().value().getMethodName()).toArray(String[]::new)))).intercept((Implementation)InvocationHandlerAdapter.of((InvocationHandler)new AopInvocationHandler(this.declWarpBean))).annotateType(beanClassAnnotation).make().load(DeclComponentProxy.class.getClassLoader(), (ClassLoadingStrategy)ClassLoadingStrategy.Default.INJECTION).getLoaded().newInstance();
            NodeComponent nodeComponent = (NodeComponent)instance;
            nodeComponent.setNodeId(this.declWarpBean.getNodeId());
            nodeComponent.setName(this.declWarpBean.getNodeName());
            return nodeComponent;
        }
        catch (Exception e) {
            throw new ProxyException(e);
        }
    }

    private Object[] loadMethodParameter(final Object proxy, final MethodWrapBean methodWrapBean, final Object[] args) {
        final NodeComponent thisNodeComponent = (NodeComponent)proxy;
        return IntStream.range(0, methodWrapBean.getParameterWrapBeanList().size()).boxed().map(new Function<Integer, Object>(){

            @Override
            public Object apply(Integer index) {
                ParameterWrapBean parameterWrapBean = methodWrapBean.getParameterWrapBeanList().get(index);
                if (parameterWrapBean.getParameterType().isAssignableFrom(NodeComponent.class)) {
                    return proxy;
                }
                if (parameterWrapBean.getFact() == null && ArrayUtil.isNotEmpty(args) && parameterWrapBean.getParameterType().isAssignableFrom(args[index - 1].getClass())) {
                    return args[index - 1];
                }
                if (parameterWrapBean.getFact() == null) {
                    return null;
                }
                Map<String, Object> contextMap = DataBus.getSlot(thisNodeComponent.getSlotIndex()).getContextBeanList().stream().collect(Collectors.toMap(tuple -> (String)tuple.get(0), tuple -> tuple.get(1)));
                ArrayList errorList = new ArrayList();
                Object result = null;
                for (Map.Entry<String, Object> entry : contextMap.entrySet()) {
                    try {
                        InstructionSet instructionSet = DeclComponentProxy.this.expressRunner.getInstructionSetFromLocalCache(entry.getKey() + "." + parameterWrapBean.getFact().value());
                        DefaultContext context = new DefaultContext();
                        context.put((Object)entry.getKey(), entry.getValue());
                        result = DeclComponentProxy.this.expressRunner.execute(instructionSet, (IExpressContext)context, errorList, false, false);
                        if (result == null) continue;
                        break;
                    }
                    catch (Exception exception) {
                    }
                }
                if (result == null) {
                    try {
                        InstructionSet instructionSet = DeclComponentProxy.this.expressRunner.getInstructionSetFromLocalCache("contextMap." + parameterWrapBean.getFact().value());
                        DefaultContext context = new DefaultContext();
                        context.put((Object)"contextMap", contextMap);
                        result = DeclComponentProxy.this.expressRunner.execute(instructionSet, (IExpressContext)context, errorList, false, false);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return result;
            }
        }).toArray();
    }

    public class AopInvocationHandler
    implements InvocationHandler {
        private final DeclWarpBean declWarpBean;

        public AopInvocationHandler(DeclWarpBean declWarpBean) {
            this.declWarpBean = declWarpBean;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            boolean checkFlag;
            MethodWrapBean currentMethodWrapBean = this.declWarpBean.getMethodWrapBeanList().stream().filter(methodWrapBean -> methodWrapBean.getLiteflowMethod().value().getMethodName().equals(method.getName())).findFirst().orElse(null);
            if (currentMethodWrapBean == null) {
                throw new ProxyException("currentMethodWrapBean is null");
            }
            boolean bl = checkFlag = currentMethodWrapBean.getMethod().getParameterTypes().length > 0 && currentMethodWrapBean.getMethod().getParameterTypes()[0].equals(NodeComponent.class);
            if (!checkFlag) {
                String errMsg = StrUtil.format("Method[{}.{}] must have NodeComponent parameter(first parameter is NodeComponent)", this.declWarpBean.getRawClazz().getName(), currentMethodWrapBean.getMethod().getName());
                DeclComponentProxy.this.LOG.error(errMsg);
                throw new ComponentMethodDefineErrorException(errMsg);
            }
            try {
                Object[] realArgs = DeclComponentProxy.this.loadMethodParameter(proxy, currentMethodWrapBean, args);
                return ReflectUtil.invoke(this.declWarpBean.getRawBean(), currentMethodWrapBean.getMethod(), realArgs);
            }
            catch (InvocationTargetRuntimeException e) {
                InvocationTargetException targetEx = (InvocationTargetException)e.getCause();
                throw targetEx.getTargetException();
            }
        }
    }
}

