/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hutool.core.util;

import com.jxdinfo.hutool.core.exceptions.UtilException;
import com.jxdinfo.hutool.core.util.EscapeUtil;
import com.jxdinfo.hutool.core.util.StrUtil;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class XmlUtil {
    public static final String NBSP = "&nbsp;";
    public static final String AMP = "&amp;";
    public static final String QUOTE = "&quot;";
    public static final String APOS = "&apos;";
    public static final String LT = "&lt;";
    public static final String GT = "&gt;";
    public static final String INVALID_REGEX = "[\\x00-\\x08\\x0b-\\x0c\\x0e-\\x1f]";
    public static final String COMMENT_REGEX = "(?s)<!--.+?-->";
    public static final int INDENT_DEFAULT = 2;
    private static String defaultDocumentBuilderFactory = "com.sun.org.apache.xerces.internal.jaxp.DocumentBuilderFactoryImpl";
    private static boolean namespaceAware = true;

    public static String toStr(Node doc) {
        return XmlUtil.toStr(doc, false);
    }

    public static String toStr(Node doc, boolean isPretty) {
        return XmlUtil.toStr(doc, "UTF-8", isPretty);
    }

    public static String toStr(Node doc, String charset, boolean isPretty) {
        return XmlUtil.toStr(doc, charset, isPretty, false);
    }

    public static String toStr(Node doc, String charset, boolean isPretty, boolean omitXmlDeclaration) {
        StringWriter writer = StrUtil.getWriter();
        try {
            XmlUtil.write(doc, writer, charset, isPretty ? 2 : 0, omitXmlDeclaration);
        }
        catch (Exception e) {
            throw new UtilException(e, "Trans xml document to string error!", new Object[0]);
        }
        return writer.toString();
    }

    public static void write(Node node, Writer writer, String charset, int indent, boolean omitXmlDeclaration) {
        XmlUtil.transform(new DOMSource(node), new StreamResult(writer), charset, indent, omitXmlDeclaration);
    }

    public static void transform(Source source, Result result, String charset, int indent, boolean omitXmlDeclaration) {
        TransformerFactory factory = TransformerFactory.newInstance();
        try {
            Transformer xformer = factory.newTransformer();
            if (indent > 0) {
                xformer.setOutputProperty("indent", "yes");
                xformer.setOutputProperty("doctype-public", "yes");
                xformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", String.valueOf(indent));
            }
            if (StrUtil.isNotBlank(charset)) {
                xformer.setOutputProperty("encoding", charset);
            }
            if (omitXmlDeclaration) {
                xformer.setOutputProperty("omit-xml-declaration", "yes");
            }
            xformer.transform(source, result);
        }
        catch (Exception e) {
            throw new UtilException(e, "Trans xml document to string error!", new Object[0]);
        }
    }

    public static Document createXml() {
        return XmlUtil.createDocumentBuilder().newDocument();
    }

    public static DocumentBuilder createDocumentBuilder() {
        DocumentBuilder builder;
        try {
            builder = XmlUtil.createDocumentBuilderFactory().newDocumentBuilder();
        }
        catch (Exception e) {
            throw new UtilException(e, "Create xml document error!", new Object[0]);
        }
        return builder;
    }

    public static DocumentBuilderFactory createDocumentBuilderFactory() {
        DocumentBuilderFactory factory = StrUtil.isNotEmpty(defaultDocumentBuilderFactory) ? DocumentBuilderFactory.newInstance(defaultDocumentBuilderFactory, null) : DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(namespaceAware);
        return XmlUtil.disableXXE(factory);
    }

    public static Document getOwnerDocument(Node node) {
        return node instanceof Document ? (Document)node : node.getOwnerDocument();
    }

    public static XPath createXPath() {
        return XPathFactory.newInstance().newXPath();
    }

    public static Object getByXPath(String expression, Object source, QName returnType, NamespaceContext nsContext) {
        XPath xPath = XmlUtil.createXPath();
        if (null != nsContext) {
            xPath.setNamespaceContext(nsContext);
        }
        try {
            if (source instanceof InputSource) {
                return xPath.evaluate(expression, (InputSource)source, returnType);
            }
            return xPath.evaluate(expression, source, returnType);
        }
        catch (XPathExpressionException e) {
            throw new UtilException(e);
        }
    }

    public static String escape(String string) {
        return EscapeUtil.escapeHtml4(string);
    }

    public static Element appendChild(Node node, String tagName) {
        return XmlUtil.appendChild(node, tagName, null);
    }

    public static Element appendChild(Node node, String tagName, String namespace) {
        Document doc = XmlUtil.getOwnerDocument(node);
        Element child = null == namespace ? doc.createElement(tagName) : doc.createElementNS(namespace, tagName);
        node.appendChild(child);
        return child;
    }

    private static void append(Document doc, Node node, Object data) {
        if (data instanceof Map) {
            XmlUtil.appendMap(doc, node, (Map)data);
        } else if (data instanceof Iterator) {
            XmlUtil.appendIterator(doc, node, (Iterator)data);
        } else if (data instanceof Iterable) {
            XmlUtil.appendIterator(doc, node, ((Iterable)data).iterator());
        } else {
            XmlUtil.appendText(doc, node, data.toString());
        }
    }

    private static void appendMap(Document doc, Node node, Map data) {
        data.forEach((key, value) -> {
            if (null != key) {
                Element child = XmlUtil.appendChild(node, key.toString());
                if (null != value) {
                    XmlUtil.append(doc, child, value);
                }
            }
        });
    }

    private static void appendIterator(Document doc, Node node, Iterator data) {
        Node parentNode = node.getParentNode();
        boolean isFirst = true;
        while (data.hasNext()) {
            Object eleData = data.next();
            if (isFirst) {
                XmlUtil.append(doc, node, eleData);
                isFirst = false;
                continue;
            }
            Node cloneNode = node.cloneNode(false);
            parentNode.appendChild(cloneNode);
            XmlUtil.append(doc, cloneNode, eleData);
        }
    }

    private static Node appendText(Document doc, Node node, CharSequence text) {
        return node.appendChild(doc.createTextNode(StrUtil.str(text)));
    }

    private static DocumentBuilderFactory disableXXE(DocumentBuilderFactory dbf) {
        try {
            String feature = "http://apache.org/xml/features/disallow-doctype-decl";
            dbf.setFeature(feature, true);
            feature = "http://xml.org/sax/features/external-general-entities";
            dbf.setFeature(feature, false);
            feature = "http://xml.org/sax/features/external-parameter-entities";
            dbf.setFeature(feature, false);
            feature = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
            dbf.setFeature(feature, false);
            dbf.setXIncludeAware(false);
            dbf.setExpandEntityReferences(false);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
        return dbf;
    }
}

