/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hutool.core.annotation.scanner;

import com.jxdinfo.hutool.core.annotation.scanner.AbstractTypeAnnotationScanner;
import com.jxdinfo.hutool.core.annotation.scanner.AnnotationScanner;
import com.jxdinfo.hutool.core.collection.CollUtil;
import com.jxdinfo.hutool.core.util.ArrayUtil;
import com.jxdinfo.hutool.core.util.ClassUtil;
import com.jxdinfo.hutool.core.util.StrUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class MethodAnnotationScanner
extends AbstractTypeAnnotationScanner<MethodAnnotationScanner>
implements AnnotationScanner {
    public MethodAnnotationScanner() {
        this(false);
    }

    public MethodAnnotationScanner(boolean scanSameSignatureMethod) {
        this(scanSameSignatureMethod, targetClass -> true, CollUtil.newLinkedHashSet(new Class[0]));
    }

    public MethodAnnotationScanner(boolean scanSameSignatureMethod, Predicate<Class<?>> filter, Set<Class<?>> excludeTypes) {
        super(scanSameSignatureMethod, scanSameSignatureMethod, filter, excludeTypes);
    }

    public MethodAnnotationScanner(boolean includeSuperClass, boolean includeInterfaces, Predicate<Class<?>> filter, Set<Class<?>> excludeTypes) {
        super(includeSuperClass, includeInterfaces, filter, excludeTypes);
    }

    @Override
    public boolean support(AnnotatedElement annotatedEle) {
        return annotatedEle instanceof Method;
    }

    @Override
    protected Class<?> getClassFormAnnotatedElement(AnnotatedElement annotatedElement) {
        return ((Method)annotatedElement).getDeclaringClass();
    }

    @Override
    protected Annotation[] getAnnotationsFromTargetClass(AnnotatedElement source, int index, Class<?> targetClass) {
        Method sourceMethod = (Method)source;
        return (Annotation[])Stream.of(ClassUtil.getDeclaredMethods(targetClass)).filter(superMethod -> !superMethod.isBridge()).filter(superMethod -> this.hasSameSignature(sourceMethod, (Method)superMethod)).map(AnnotatedElement::getAnnotations).flatMap(Stream::of).toArray(Annotation[]::new);
    }

    public MethodAnnotationScanner setScanSameSignatureMethod(boolean scanSuperMethodIfOverride) {
        this.setIncludeInterfaces(scanSuperMethodIfOverride);
        this.setIncludeSuperClass(scanSuperMethodIfOverride);
        return this;
    }

    private boolean hasSameSignature(Method sourceMethod, Method superMethod) {
        Class<?>[] targetParameterTypes;
        if (!StrUtil.equals(sourceMethod.getName(), superMethod.getName())) {
            return false;
        }
        Class<?>[] sourceParameterTypes = sourceMethod.getParameterTypes();
        if (sourceParameterTypes.length != (targetParameterTypes = superMethod.getParameterTypes()).length) {
            return false;
        }
        if (!ArrayUtil.containsAll(sourceParameterTypes, targetParameterTypes)) {
            return false;
        }
        return ClassUtil.isAssignable(superMethod.getReturnType(), sourceMethod.getReturnType());
    }
}

