/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.liteflow.flow.element.condition;

import com.jxdinfo.hutool.core.util.ObjectUtil;
import com.jxdinfo.hutool.core.util.StrUtil;
import com.jxdinfo.liteflow.enums.ConditionTypeEnum;
import com.jxdinfo.liteflow.exception.IfTargetCannotBePreOrFinallyException;
import com.jxdinfo.liteflow.exception.NoIfTrueNodeException;
import com.jxdinfo.liteflow.flow.element.Condition;
import com.jxdinfo.liteflow.flow.element.Executable;
import com.jxdinfo.liteflow.flow.element.condition.FinallyCondition;
import com.jxdinfo.liteflow.flow.element.condition.PreCondition;
import com.jxdinfo.liteflow.slot.DataBus;
import com.jxdinfo.liteflow.slot.Slot;

public class IfCondition
extends Condition {
    @Override
    public void executeCondition(Integer slotIndex) throws Exception {
        Executable ifItem = this.getIfItem();
        ifItem.setCurrChainId(this.getCurrChainId());
        if (!ifItem.isAccess(slotIndex)) {
            return;
        }
        ifItem.execute(slotIndex);
        boolean ifResult = (Boolean)ifItem.getItemResultMetaValue(slotIndex);
        Executable trueCaseExecutableItem = this.getTrueCaseExecutableItem();
        Executable falseCaseExecutableItem = this.getFalseCaseExecutableItem();
        Slot slot = DataBus.getSlot(slotIndex);
        if (ifResult) {
            if (ObjectUtil.isNull(trueCaseExecutableItem)) {
                String errorInfo = StrUtil.format("[{}]:no if-true node found for the component[{}]", slot.getRequestId(), ifItem.getId());
                throw new NoIfTrueNodeException(errorInfo);
            }
            if (trueCaseExecutableItem instanceof PreCondition || trueCaseExecutableItem instanceof FinallyCondition) {
                String errorInfo = StrUtil.format("[{}]:if component[{}] error, if true node cannot be pre or finally", slot.getRequestId(), ifItem.getId());
                throw new IfTargetCannotBePreOrFinallyException(errorInfo);
            }
            trueCaseExecutableItem.setCurrChainId(this.getCurrChainId());
            trueCaseExecutableItem.execute(slotIndex);
        } else if (ObjectUtil.isNotNull(falseCaseExecutableItem)) {
            if (falseCaseExecutableItem instanceof PreCondition || falseCaseExecutableItem instanceof FinallyCondition) {
                String errorInfo = StrUtil.format("[{}]:if component[{}] error, if true node cannot be pre or finally", slot.getRequestId(), ifItem.getId());
                throw new IfTargetCannotBePreOrFinallyException(errorInfo);
            }
            falseCaseExecutableItem.setCurrChainId(this.getCurrChainId());
            falseCaseExecutableItem.execute(slotIndex);
        }
    }

    @Override
    public ConditionTypeEnum getConditionType() {
        return ConditionTypeEnum.TYPE_IF;
    }

    public Executable getTrueCaseExecutableItem() {
        return this.getExecutableOne("IF_TRUE_CASE_KEY");
    }

    public void setTrueCaseExecutableItem(Executable trueCaseExecutableItem) {
        this.addExecutable("IF_TRUE_CASE_KEY", trueCaseExecutableItem);
    }

    public Executable getFalseCaseExecutableItem() {
        return this.getExecutableOne("IF_FALSE_CASE_KEY");
    }

    public void setFalseCaseExecutableItem(Executable falseCaseExecutableItem) {
        this.addExecutable("IF_FALSE_CASE_KEY", falseCaseExecutableItem);
    }

    public void setIfItem(Executable ifNode) {
        this.addExecutable("IF_KEY", ifNode);
    }

    public Executable getIfItem() {
        return this.getExecutableOne("IF_KEY");
    }
}

