/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.liteflow.core;

import com.jxdinfo.hutool.core.util.ObjectUtil;
import com.jxdinfo.hutool.core.util.StrUtil;
import com.jxdinfo.liteflow.annotation.LiteflowRetry;
import com.jxdinfo.liteflow.annotation.util.AnnoUtil;
import com.jxdinfo.liteflow.core.NodeComponent;
import com.jxdinfo.liteflow.enums.NodeTypeEnum;
import com.jxdinfo.liteflow.flow.executor.NodeExecutor;
import com.jxdinfo.liteflow.monitor.MonitorBus;
import com.jxdinfo.liteflow.property.LiteflowConfig;
import com.jxdinfo.liteflow.property.LiteflowConfigGetter;
import com.jxdinfo.liteflow.spi.holder.ContextAwareHolder;
import com.jxdinfo.liteflow.spi.holder.LiteflowComponentSupportHolder;

public class ComponentInitializer {
    private static ComponentInitializer instance;

    public static ComponentInitializer loadInstance() {
        if (ObjectUtil.isNull(instance)) {
            instance = new ComponentInitializer();
        }
        return instance;
    }

    public NodeComponent initComponent(NodeComponent nodeComponent, NodeTypeEnum type, String name, String nodeId) {
        MonitorBus monitorBus;
        nodeComponent.setNodeId(nodeId);
        nodeComponent.setSelf(nodeComponent);
        nodeComponent.setType(type);
        if (ContextAwareHolder.loadContextAware().hasBean("monitorBus") && ObjectUtil.isNotNull(monitorBus = ContextAwareHolder.loadContextAware().getBean(MonitorBus.class))) {
            nodeComponent.setMonitorBus(monitorBus);
        }
        nodeComponent.setName(name);
        if (!type.isScript() && StrUtil.isBlank(nodeComponent.getName())) {
            nodeComponent.setName(LiteflowComponentSupportHolder.loadLiteflowComponentSupport().getCmpName(nodeComponent));
        }
        LiteflowRetry liteFlowRetryAnnotation = AnnoUtil.getAnnotation(nodeComponent.getClass(), LiteflowRetry.class);
        LiteflowConfig liteflowConfig = LiteflowConfigGetter.get();
        if (liteFlowRetryAnnotation != null) {
            nodeComponent.setRetryCount(liteFlowRetryAnnotation.retry());
            nodeComponent.setRetryForExceptions(liteFlowRetryAnnotation.forExceptions());
        } else {
            nodeComponent.setRetryCount(liteflowConfig.getRetryCount());
        }
        nodeComponent.setNodeExecutorClass(this.buildNodeExecutorClass(liteflowConfig));
        return nodeComponent;
    }

    private Class<? extends NodeExecutor> buildNodeExecutorClass(LiteflowConfig liteflowConfig) {
        Class<?> nodeExecutorClass;
        try {
            nodeExecutorClass = Class.forName(liteflowConfig.getNodeExecutorClass());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e.getMessage());
        }
        return nodeExecutorClass;
    }
}

