/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.liteflow.monitor;

import com.jxdinfo.hutool.core.io.FileUtil;
import com.jxdinfo.hutool.core.lang.Singleton;
import com.jxdinfo.liteflow.core.FlowExecutorHolder;
import com.jxdinfo.liteflow.log.LFLog;
import com.jxdinfo.liteflow.log.LFLoggerManager;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.monitor.FileAlterationListener;
import org.apache.commons.io.monitor.FileAlterationListenerAdaptor;
import org.apache.commons.io.monitor.FileAlterationMonitor;
import org.apache.commons.io.monitor.FileAlterationObserver;

public class MonitorFile {
    private final LFLog LOG = LFLoggerManager.getLogger(this.getClass());
    private final Set<String> PATH_SET = new HashSet<String>();

    public static MonitorFile getInstance() {
        return Singleton.get(MonitorFile.class, new Object[0]);
    }

    public void addMonitorFilePath(String path) {
        if (FileUtil.isFile(path)) {
            String parentFolder = FileUtil.getParent(path, 1);
            this.PATH_SET.add(parentFolder);
        } else {
            this.PATH_SET.add(path);
        }
    }

    public void addMonitorFilePaths(List<String> filePaths) {
        filePaths.forEach(this::addMonitorFilePath);
    }

    public void create() throws Exception {
        for (String path : this.PATH_SET) {
            long interval = TimeUnit.MILLISECONDS.toMillis(2L);
            FileAlterationObserver observer = new FileAlterationObserver(new File(path));
            observer.addListener((FileAlterationListener)new FileAlterationListenerAdaptor(){

                public void onFileChange(File file) {
                    MonitorFile.this.LOG.info("file modify,filePath={}", (Object)file.getAbsolutePath());
                    this.reloadRule();
                }

                public void onFileDelete(File file) {
                    MonitorFile.this.LOG.info("file delete,filePath={}", (Object)file.getAbsolutePath());
                    this.reloadRule();
                }

                private void reloadRule() {
                    try {
                        FlowExecutorHolder.loadInstance().reloadRule();
                    }
                    catch (Exception e) {
                        MonitorFile.this.LOG.error("reload rule error", e);
                    }
                }
            });
            FileAlterationMonitor monitor = new FileAlterationMonitor(interval, new FileAlterationObserver[]{observer});
            monitor.start();
        }
    }
}

