/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hutool.core.collection;

import com.jxdinfo.hutool.core.collection.IterableIter;
import com.jxdinfo.hutool.core.collection.ResettableIter;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.NoSuchElementException;

public class ArrayIter<E>
implements IterableIter<E>,
ResettableIter<E>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Object array;
    private int startIndex;
    private int endIndex;
    private int index;

    public ArrayIter(E[] array) {
        this((Object)array);
    }

    public ArrayIter(Object array) {
        this(array, 0);
    }

    public ArrayIter(Object array, int startIndex) {
        this(array, startIndex, -1);
    }

    public ArrayIter(Object array, int startIndex, int endIndex) {
        this.endIndex = Array.getLength(array);
        if (endIndex > 0 && endIndex < this.endIndex) {
            this.endIndex = endIndex;
        }
        if (startIndex >= 0 && startIndex < this.endIndex) {
            this.startIndex = startIndex;
        }
        this.array = array;
        this.index = this.startIndex;
    }

    @Override
    public boolean hasNext() {
        return this.index < this.endIndex;
    }

    @Override
    public E next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return (E)Array.get(this.array, this.index++);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove() method is not supported");
    }

    public Object getArray() {
        return this.array;
    }

    @Override
    public void reset() {
        this.index = this.startIndex;
    }
}

