/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.liteflow.flow.parallel.strategy;

import com.jxdinfo.hutool.core.util.BooleanUtil;
import com.jxdinfo.hutool.core.util.ObjectUtil;
import com.jxdinfo.hutool.core.util.StrUtil;
import com.jxdinfo.liteflow.exception.WhenExecuteException;
import com.jxdinfo.liteflow.flow.element.Executable;
import com.jxdinfo.liteflow.flow.element.Node;
import com.jxdinfo.liteflow.flow.element.condition.FinallyCondition;
import com.jxdinfo.liteflow.flow.element.condition.PreCondition;
import com.jxdinfo.liteflow.flow.element.condition.WhenCondition;
import com.jxdinfo.liteflow.flow.parallel.CompletableFutureExpand;
import com.jxdinfo.liteflow.flow.parallel.ParallelSupplier;
import com.jxdinfo.liteflow.flow.parallel.WhenFutureObj;
import com.jxdinfo.liteflow.log.LFLog;
import com.jxdinfo.liteflow.log.LFLoggerManager;
import com.jxdinfo.liteflow.property.LiteflowConfig;
import com.jxdinfo.liteflow.property.LiteflowConfigGetter;
import com.jxdinfo.liteflow.slot.DataBus;
import com.jxdinfo.liteflow.slot.Slot;
import com.jxdinfo.liteflow.thread.ExecutorHelper;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class ParallelStrategyExecutor {
    protected final LFLog LOG = LFLoggerManager.getLogger(this.getClass());

    protected CompletableFuture<WhenFutureObj> wrappedFutureObj(Executable executable, ExecutorService parallelExecutor, WhenCondition whenCondition, String currChainId, Integer slotIndex) {
        return CompletableFutureExpand.completeOnTimeout(CompletableFuture.supplyAsync(new ParallelSupplier(executable, currChainId, slotIndex), parallelExecutor), whenCondition.getMaxWaitTime().intValue(), whenCondition.getMaxWaitTimeUnit(), WhenFutureObj.timeOut(executable.getId()));
    }

    protected void setWhenConditionParams(WhenCondition whenCondition) {
        LiteflowConfig liteflowConfig = LiteflowConfigGetter.get();
        if (ObjectUtil.isNull(whenCondition.getMaxWaitTime())) {
            if (ObjectUtil.isNotNull(liteflowConfig.getWhenMaxWaitSeconds())) {
                whenCondition.setMaxWaitTime(liteflowConfig.getWhenMaxWaitSeconds());
                whenCondition.setMaxWaitTimeUnit(TimeUnit.SECONDS);
            } else {
                whenCondition.setMaxWaitTime(liteflowConfig.getWhenMaxWaitTime());
            }
        }
        if (ObjectUtil.isNull((Object)whenCondition.getMaxWaitTimeUnit())) {
            whenCondition.setMaxWaitTimeUnit(liteflowConfig.getWhenMaxWaitTimeUnit());
        }
    }

    protected Stream<Executable> filterWhenTaskList(List<Executable> executableList, Integer slotIndex, String currentChainId) {
        Stream<Executable> stream = executableList.stream().filter(executable -> !(executable instanceof PreCondition) && !(executable instanceof FinallyCondition));
        return this.filterAccess(stream, slotIndex, currentChainId);
    }

    protected Stream<Executable> filterAccess(Stream<Executable> stream, Integer slotIndex, String currentChainId) {
        return stream.filter(executable -> {
            try {
                executable.setCurrChainId(currentChainId);
                boolean access = executable.isAccess(slotIndex);
                if (executable instanceof Node) {
                    ((Node)executable).setAccessResult(access);
                }
                return access;
            }
            catch (Exception e) {
                this.LOG.error("there was an error when executing the when component isAccess", e);
                return false;
            }
        });
    }

    protected ExecutorService getWhenExecutorService(WhenCondition whenCondition) {
        LiteflowConfig liteflowConfig = LiteflowConfigGetter.get();
        ExecutorService parallelExecutor = BooleanUtil.isTrue(liteflowConfig.getWhenThreadPoolIsolate()) ? ExecutorHelper.loadInstance().buildWhenExecutorWithHash(whenCondition.getThreadExecutorClass(), String.valueOf(whenCondition.hashCode())) : ExecutorHelper.loadInstance().buildWhenExecutor(whenCondition.getThreadExecutorClass());
        return parallelExecutor;
    }

    protected List<CompletableFuture<WhenFutureObj>> getWhenAllTaskList(WhenCondition whenCondition, Integer slotIndex) {
        String currChainId = whenCondition.getCurrChainId();
        this.setWhenConditionParams(whenCondition);
        ExecutorService parallelExecutor = this.getWhenExecutorService(whenCondition);
        List<CompletableFuture<WhenFutureObj>> completableFutureList = this.filterWhenTaskList(whenCondition.getExecutableList(), slotIndex, currChainId).map(executable -> this.wrappedFutureObj((Executable)executable, parallelExecutor, whenCondition, currChainId, slotIndex)).collect(Collectors.toList());
        return completableFutureList;
    }

    protected void handleTaskResult(WhenCondition whenCondition, Integer slotIndex, List<CompletableFuture<WhenFutureObj>> whenAllFutureList, CompletableFuture<?> specifyTask) throws Exception {
        Slot slot = DataBus.getSlot(slotIndex);
        boolean[] interrupted = new boolean[]{false};
        try {
            specifyTask.get();
        }
        catch (InterruptedException | ExecutionException e) {
            this.LOG.error("there was an error when executing the CompletableFuture", e);
            interrupted[0] = true;
        }
        List allCompletableWhenFutureObjList = whenAllFutureList.stream().filter(f -> {
            if (f.isDone()) {
                return true;
            }
            f.cancel(true);
            return false;
        }).map(f -> {
            try {
                WhenFutureObj whenFutureObj = (WhenFutureObj)f.get();
                if (whenFutureObj.isTimeout()) {
                    f.cancel(true);
                }
                return whenFutureObj;
            }
            catch (InterruptedException | ExecutionException e) {
                interrupted[0] = true;
                return WhenFutureObj.fail("Unknown", e);
            }
        }).collect(Collectors.toList());
        List<WhenFutureObj> timeOutWhenFutureObjList = allCompletableWhenFutureObjList.stream().filter(WhenFutureObj::isTimeout).collect(Collectors.toList());
        timeOutWhenFutureObjList.forEach(whenFutureObj -> {
            slot.addTimeoutItem(whenFutureObj.getExecutorId());
            this.LOG.warn("executing thread has reached max-wait-seconds, thread canceled.Execute-item: [{}]", (Object)whenFutureObj.getExecutorId());
        });
        if (!whenCondition.isIgnoreError()) {
            if (interrupted[0]) {
                throw new WhenExecuteException(StrUtil.format("requestId [{}] when execute interrupted. errorResume [false].", slot.getRequestId()));
            }
            for (WhenFutureObj whenFutureObj2 : allCompletableWhenFutureObjList) {
                if (whenFutureObj2.isSuccess()) continue;
                this.LOG.info(StrUtil.format("when-executor[{}] execute failed. errorResume [false].", whenFutureObj2.getExecutorId()));
                throw whenFutureObj2.getEx();
            }
        } else if (interrupted[0]) {
            this.LOG.warn("executing when condition timeout , but ignore with errorResume.");
        }
    }

    public abstract void execute(WhenCondition var1, Integer var2) throws Exception;
}

