/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hutool.core.annotation;

import com.jxdinfo.hutool.core.annotation.AnnotationAttribute;
import com.jxdinfo.hutool.core.annotation.WrappedAnnotationAttribute;
import com.jxdinfo.hutool.core.lang.Assert;
import com.jxdinfo.hutool.core.util.ObjectUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class AbstractWrappedAnnotationAttribute
implements WrappedAnnotationAttribute {
    protected final AnnotationAttribute original;
    protected final AnnotationAttribute linked;

    protected AbstractWrappedAnnotationAttribute(AnnotationAttribute original, AnnotationAttribute linked) {
        Assert.notNull(original, "target must not null", new Object[0]);
        Assert.notNull(linked, "linked must not null", new Object[0]);
        this.original = original;
        this.linked = linked;
    }

    @Override
    public AnnotationAttribute getOriginal() {
        return this.original;
    }

    @Override
    public AnnotationAttribute getLinked() {
        return this.linked;
    }

    @Override
    public AnnotationAttribute getNonWrappedOriginal() {
        AnnotationAttribute curr = null;
        AnnotationAttribute next = this.original;
        while (next != null) {
            curr = next;
            next = next.isWrapped() ? ((WrappedAnnotationAttribute)curr).getOriginal() : null;
        }
        return curr;
    }

    @Override
    public Collection<AnnotationAttribute> getAllLinkedNonWrappedAttributes() {
        ArrayList<AnnotationAttribute> leafAttributes = new ArrayList<AnnotationAttribute>();
        this.collectLeafAttribute(this, leafAttributes);
        return leafAttributes;
    }

    private void collectLeafAttribute(AnnotationAttribute curr, List<AnnotationAttribute> leafAttributes) {
        if (ObjectUtil.isNull(curr)) {
            return;
        }
        if (!curr.isWrapped()) {
            leafAttributes.add(curr);
            return;
        }
        WrappedAnnotationAttribute wrappedAttribute = (WrappedAnnotationAttribute)curr;
        this.collectLeafAttribute(wrappedAttribute.getOriginal(), leafAttributes);
        this.collectLeafAttribute(wrappedAttribute.getLinked(), leafAttributes);
    }
}

