/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.liteflow.parser.factory;

import com.jxdinfo.liteflow.parser.base.BaseJsonFlowParser;
import com.jxdinfo.liteflow.parser.base.BaseXmlFlowParser;
import com.jxdinfo.liteflow.parser.base.BaseYmlFlowParser;
import com.jxdinfo.liteflow.parser.el.JsonFlowELParser;
import com.jxdinfo.liteflow.parser.el.XmlFlowELParser;
import com.jxdinfo.liteflow.parser.el.YmlFlowELParser;
import com.jxdinfo.liteflow.parser.factory.FlowParserFactory;
import com.jxdinfo.liteflow.spi.holder.ContextAwareHolder;

public class ClassParserFactory
implements FlowParserFactory {
    @Override
    public BaseJsonFlowParser createJsonELParser(String path) {
        Class<?> c = this.forName(path);
        return (JsonFlowELParser)ContextAwareHolder.loadContextAware().registerBean(c);
    }

    @Override
    public BaseXmlFlowParser createXmlELParser(String path) {
        Class<?> c = this.forName(path);
        return (XmlFlowELParser)ContextAwareHolder.loadContextAware().registerBean(c);
    }

    @Override
    public BaseYmlFlowParser createYmlELParser(String path) {
        Class<?> c = this.forName(path);
        return (YmlFlowELParser)ContextAwareHolder.loadContextAware().registerBean(c);
    }

    private Class<?> forName(String path) {
        try {
            return Class.forName(path);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

