/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.liteflow.parser.helper;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.jxdinfo.hutool.core.util.ObjectUtil;
import com.jxdinfo.hutool.core.util.StrUtil;
import com.jxdinfo.liteflow.builder.LiteFlowNodeBuilder;
import com.jxdinfo.liteflow.builder.el.LiteFlowChainELBuilder;
import com.jxdinfo.liteflow.builder.prop.NodePropBean;
import com.jxdinfo.liteflow.enums.NodeTypeEnum;
import com.jxdinfo.liteflow.exception.ChainDuplicateException;
import com.jxdinfo.liteflow.exception.ChainNotFoundException;
import com.jxdinfo.liteflow.exception.FlowSystemException;
import com.jxdinfo.liteflow.exception.NodeClassNotFoundException;
import com.jxdinfo.liteflow.exception.NodeTypeCanNotGuessException;
import com.jxdinfo.liteflow.exception.NodeTypeNotSupportException;
import com.jxdinfo.liteflow.exception.ParseException;
import com.jxdinfo.liteflow.flow.FlowBus;
import com.jxdinfo.liteflow.flow.element.Chain;
import com.jxdinfo.liteflow.flow.element.condition.AbstractCondition;
import com.jxdinfo.liteflow.util.ElRegexUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import org.dom4j.Document;
import org.dom4j.Element;

public class ParserHelper {
    private ParserHelper() {
    }

    public static void buildNode(NodePropBean nodePropBean) {
        String id = nodePropBean.getId();
        String name = nodePropBean.getName();
        String clazz = nodePropBean.getClazz();
        String script = nodePropBean.getScript();
        String type = nodePropBean.getType();
        String file = nodePropBean.getFile();
        String language = nodePropBean.getLanguage();
        if (StrUtil.isNotBlank(clazz)) {
            try {
                Class<?> c = Class.forName(clazz);
                NodeTypeEnum nodeType = NodeTypeEnum.guessType(c);
                if (nodeType != null) {
                    type = nodeType.getCode();
                }
            }
            catch (Exception e) {
                throw new NodeClassNotFoundException(StrUtil.format("cannot find the node[{}]", clazz));
            }
        }
        if (StrUtil.isBlank(type)) {
            throw new NodeTypeCanNotGuessException(StrUtil.format("cannot guess the type of node[{}]", clazz));
        }
        NodeTypeEnum nodeTypeEnum = NodeTypeEnum.getEnumByCode(type);
        if (ObjectUtil.isNull((Object)nodeTypeEnum)) {
            throw new NodeTypeNotSupportException(StrUtil.format("type [{}] is not support", type));
        }
        LiteFlowNodeBuilder.createNode().setId(id).setName(name).setClazz(clazz).setType(nodeTypeEnum).setScript(script).setFile(file).setLanguage(language).build();
    }

    public static void parseNodeDocument(List<Document> documentList) {
        for (Document document : documentList) {
            Element rootElement = document.getRootElement();
            Element nodesElement = rootElement.element("nodes");
            if (!ObjectUtil.isNotNull(nodesElement)) continue;
            List nodeList = nodesElement.elements("node");
            for (Element e : nodeList) {
                String id = e.attributeValue("id");
                String name = e.attributeValue("name");
                String clazz = e.attributeValue("class");
                String type = e.attributeValue("type");
                String script = e.getText();
                String file = e.attributeValue("file");
                String language = e.attributeValue("language");
                if (!ParserHelper.getEnableByElement(e).booleanValue()) continue;
                NodePropBean nodePropBean = new NodePropBean().setId(id).setName(name).setClazz(clazz).setScript(script).setType(type).setFile(file).setLanguage(language);
                ParserHelper.buildNode(nodePropBean);
            }
        }
    }

    public static void parseChainDocument(List<Document> documentList, Set<String> chainIdSet, Consumer<Element> parseOneChainConsumer) {
        HashMap<String, Element> abstratChainMap = new HashMap<String, Element>();
        HashSet<Element> implChainSet = new HashSet<Element>();
        documentList.forEach(document -> {
            List chainList = document.getRootElement().elements("chain");
            for (Element e : chainList) {
                String chainId = Optional.ofNullable(e.attributeValue("id")).orElse(e.attributeValue("name"));
                ParserHelper.checkChainId(chainId, e.getText());
                if (!chainIdSet.add(chainId)) {
                    throw new ChainDuplicateException(StrUtil.format("[chain name duplicate] chainName={}", chainId));
                }
                if (!ParserHelper.getEnableByElement(e).booleanValue()) continue;
                FlowBus.addChain(chainId);
                if (!ElRegexUtil.isAbstractChain(e.getText())) continue;
                abstratChainMap.put(chainId, e);
                Chain chain = FlowBus.getChain(chainId);
                chain.getConditionList().add(new AbstractCondition());
            }
        });
        chainIdSet.clear();
        for (Document document2 : documentList) {
            Element rootElement = document2.getRootElement();
            List chainList = rootElement.elements("chain");
            for (Element chain : chainList) {
                if (!ParserHelper.getEnableByElement(chain).booleanValue()) continue;
                ParserHelper.parseImplChain(abstratChainMap, implChainSet, chain);
                String chainName = Optional.ofNullable(chain.attributeValue("id")).orElse(chain.attributeValue("name"));
                if (abstratChainMap.containsKey(chainName)) continue;
                parseOneChainConsumer.accept(chain);
            }
        }
    }

    public static void parseNodeJson(List<JsonNode> flowJsonObjectList) {
        for (JsonNode flowJsonNode : flowJsonObjectList) {
            if (!flowJsonNode.get("flow").has("nodes")) continue;
            Iterator nodeIterator = flowJsonNode.get("flow").get("nodes").get("node").elements();
            while (nodeIterator.hasNext()) {
                String language;
                JsonNode nodeObject = (JsonNode)nodeIterator.next();
                String id = nodeObject.get("id").textValue();
                String name = nodeObject.hasNonNull("name") ? nodeObject.get("name").textValue() : "";
                String clazz = nodeObject.hasNonNull("class") ? nodeObject.get("class").textValue() : "";
                String type = nodeObject.hasNonNull("type") ? nodeObject.get("type").textValue() : null;
                String script = nodeObject.hasNonNull("value") ? nodeObject.get("value").textValue() : "";
                String file = nodeObject.hasNonNull("file") ? nodeObject.get("file").textValue() : "";
                String string = language = nodeObject.hasNonNull("language") ? nodeObject.get("language").textValue() : "";
                if (!ParserHelper.getEnableByJsonNode(nodeObject).booleanValue()) continue;
                NodePropBean nodePropBean = new NodePropBean().setId(id).setName(name).setClazz(clazz).setScript(script).setType(type).setFile(file).setLanguage(language);
                ParserHelper.buildNode(nodePropBean);
            }
        }
    }

    public static void parseChainJson(List<JsonNode> flowJsonObjectList, Set<String> chainIdSet, Consumer<JsonNode> parseOneChainConsumer) {
        HashMap<String, JsonNode> abstratChainMap = new HashMap<String, JsonNode>();
        HashSet<JsonNode> implChainSet = new HashSet<JsonNode>();
        flowJsonObjectList.forEach(jsonObject -> {
            Iterator iterator = jsonObject.get("flow").get("chain").elements();
            while (iterator.hasNext()) {
                JsonNode innerJsonObject = (JsonNode)iterator.next();
                JsonNode chainNameJsonNode = Optional.ofNullable(innerJsonObject.get("id")).orElse(innerJsonObject.get("name"));
                String chainId = Optional.ofNullable(chainNameJsonNode).map(JsonNode::textValue).orElse(null);
                ParserHelper.checkChainId(chainId, innerJsonObject.toString());
                if (!chainIdSet.add(chainId)) {
                    throw new ChainDuplicateException(String.format("[chain id duplicate] chainId=%s", chainId));
                }
                if (!ParserHelper.getEnableByJsonNode(innerJsonObject).booleanValue()) continue;
                FlowBus.addChain(chainId);
                if (!ElRegexUtil.isAbstractChain(innerJsonObject.get("value").textValue())) continue;
                abstratChainMap.put(chainId, innerJsonObject);
                Chain chain = FlowBus.getChain(chainId);
                chain.getConditionList().add(new AbstractCondition());
            }
        });
        chainIdSet.clear();
        for (JsonNode flowJsonNode : flowJsonObjectList) {
            Iterator chainIterator = flowJsonNode.get("flow").get("chain").elements();
            while (chainIterator.hasNext()) {
                JsonNode chainNode = (JsonNode)chainIterator.next();
                if (!ParserHelper.getEnableByJsonNode(chainNode).booleanValue()) continue;
                ParserHelper.parseImplChain(abstratChainMap, implChainSet, chainNode);
                JsonNode chainNameJsonNode = Optional.ofNullable(chainNode.get("id")).orElse(chainNode.get("name"));
                String chainId = Optional.ofNullable(chainNameJsonNode).map(JsonNode::textValue).orElse(null);
                if (abstratChainMap.containsKey(chainId)) continue;
                parseOneChainConsumer.accept(chainNode);
            }
        }
    }

    public static void parseOneChainEl(JsonNode chainNode) {
        String chainId = Optional.ofNullable(chainNode.get("id")).orElse(chainNode.get("name")).textValue();
        String namespace = chainNode.get("namespace") == null ? "default" : chainNode.get("namespace").textValue();
        JsonNode routeJsonNode = chainNode.get("route");
        LiteFlowChainELBuilder builder = LiteFlowChainELBuilder.createChain().setChainId(chainId).setNamespace(namespace);
        if (routeJsonNode != null) {
            builder.setRoute(routeJsonNode.textValue());
            JsonNode bodyJsonNode = chainNode.get("value");
            if (bodyJsonNode == null) {
                String errMsg = StrUtil.format("If you have defined the field route, then you must define the field body in chain[{}]", chainId);
                throw new FlowSystemException(errMsg);
            }
            builder.setEL(bodyJsonNode.textValue());
        } else {
            builder.setEL(chainNode.get("value").textValue());
        }
        builder.build();
    }

    public static void parseOneChainEl(Element e) {
        String chainId = Optional.ofNullable(e.attributeValue("id")).orElse(e.attributeValue("name"));
        String namespace = StrUtil.blankToDefault(e.attributeValue("namespace"), "default");
        Element routeElement = e.element("route");
        LiteFlowChainELBuilder builder = LiteFlowChainELBuilder.createChain().setChainId(chainId).setNamespace(namespace);
        if (routeElement != null) {
            builder.setRoute(ElRegexUtil.removeComments(routeElement.getText()));
            Element bodyElement = e.element("body");
            if (bodyElement == null) {
                String errMsg = StrUtil.format("If you have defined the tag <route>, then you must define the tag <body> in chain[{}]", chainId);
                throw new FlowSystemException(errMsg);
            }
            builder.setEL(ElRegexUtil.removeComments(bodyElement.getText()));
        } else {
            Element bodyElement = e.element("body");
            if (bodyElement != null) {
                builder.setEL(ElRegexUtil.removeComments(bodyElement.getText()));
            } else {
                builder.setEL(ElRegexUtil.removeComments(e.getText()));
            }
        }
        builder.build();
    }

    private static void checkChainId(String chainId, String elData) {
        if (StrUtil.isBlank(chainId)) {
            throw new ParseException("missing chain id in expression \r\n" + elData);
        }
    }

    private static void parseImplChain(Map<String, Element> abstratChainMap, Set<Element> implChainSet, Element chain) {
        if (ObjectUtil.isNotNull(chain.attributeValue("extends"))) {
            String baseChainId = chain.attributeValue("extends");
            Element baseChain = abstratChainMap.get(baseChainId);
            if (baseChain != null) {
                ParserHelper.internalParseImplChain(baseChain, chain, abstratChainMap, implChainSet);
            } else {
                throw new ChainNotFoundException(StrUtil.format("[abstract chain not found] chainName={}", baseChainId));
            }
        }
    }

    private static void parseImplChain(Map<String, JsonNode> abstratChainMap, Set<JsonNode> implChainSet, JsonNode chainNode) {
        if (chainNode.hasNonNull("extends")) {
            String baseChainId = chainNode.get("extends").textValue();
            JsonNode baseChain = abstratChainMap.get(baseChainId);
            if (baseChain != null) {
                ParserHelper.internalParseImplChain(baseChain, chainNode, abstratChainMap, implChainSet);
            } else {
                throw new ChainNotFoundException(StrUtil.format("[abstract chain not found] chainName={}", baseChainId));
            }
        }
    }

    private static void internalParseImplChain(JsonNode baseChain, JsonNode implChain, Map<String, JsonNode> abstractChainMap, Set<JsonNode> implChainSet) {
        if (implChainSet.contains(implChain)) {
            return;
        }
        ParserHelper.parseImplChain(abstractChainMap, implChainSet, baseChain);
        String implChainEl = implChain.get("value").textValue();
        String baseChainEl = baseChain.get("value").textValue();
        String parsedEl = ElRegexUtil.replaceAbstractChain(baseChainEl, implChainEl);
        ObjectNode objectNode = (ObjectNode)implChain;
        objectNode.put("value", parsedEl);
        implChainSet.add(implChain);
    }

    private static void internalParseImplChain(Element baseChain, Element implChain, Map<String, Element> abstractChainMap, Set<Element> implChainSet) {
        if (implChainSet.contains(implChain)) {
            return;
        }
        ParserHelper.parseImplChain(abstractChainMap, implChainSet, baseChain);
        String implChainEl = implChain.getText();
        String baseChainEl = baseChain.getText();
        String parsedEl = ElRegexUtil.replaceAbstractChain(baseChainEl, implChainEl);
        implChain.setText(parsedEl);
        implChainSet.add(implChain);
    }

    private static Boolean getEnableByElement(Element element) {
        String enableStr = element.attributeValue("enable");
        if (StrUtil.isBlank(enableStr)) {
            return true;
        }
        return Boolean.TRUE.toString().equalsIgnoreCase(enableStr);
    }

    private static Boolean getEnableByJsonNode(JsonNode nodeObject) {
        String enableStr;
        String string = enableStr = nodeObject.hasNonNull("enable") ? nodeObject.get("enable").toString() : "";
        if (StrUtil.isBlank(enableStr)) {
            return true;
        }
        return Boolean.TRUE.toString().equalsIgnoreCase(enableStr);
    }
}

