/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.liteflow.parser.base;

import com.fasterxml.jackson.databind.JsonNode;
import com.jxdinfo.hutool.core.collection.CollectionUtil;
import com.jxdinfo.hutool.core.collection.ListUtil;
import com.jxdinfo.liteflow.parser.base.FlowParser;
import com.jxdinfo.liteflow.parser.helper.ParserHelper;
import com.jxdinfo.liteflow.util.JsonUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.yaml.snakeyaml.Yaml;

public abstract class BaseYmlFlowParser
implements FlowParser {
    private final Set<String> CHAIN_NAME_SET = new HashSet<String>();

    public void parse(String content) throws Exception {
        this.parse(ListUtil.toList(content));
    }

    @Override
    public void parse(List<String> contentList) throws Exception {
        if (CollectionUtil.isEmpty(contentList)) {
            return;
        }
        ArrayList<JsonNode> jsonObjectList = ListUtil.toList(new JsonNode[0]);
        for (String content : contentList) {
            JsonNode ruleObject = this.convertToJson(content);
            jsonObjectList.add(ruleObject);
        }
        Consumer<JsonNode> parseOneChainConsumer = this::parseOneChain;
        ParserHelper.parseNodeJson(jsonObjectList);
        ParserHelper.parseChainJson(jsonObjectList, this.CHAIN_NAME_SET, parseOneChainConsumer);
    }

    protected JsonNode convertToJson(String yamlString) {
        Yaml yaml = new Yaml();
        Map map = (Map)yaml.load(yamlString);
        return JsonUtil.parseObject(JsonUtil.toJsonString(map));
    }

    public abstract void parseOneChain(JsonNode var1);
}

