/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.liteflow.flow.executor;

import com.jxdinfo.liteflow.core.NodeComponent;
import com.jxdinfo.liteflow.exception.ChainEndException;
import com.jxdinfo.liteflow.log.LFLog;
import com.jxdinfo.liteflow.log.LFLoggerManager;
import com.jxdinfo.liteflow.slot.DataBus;
import com.jxdinfo.liteflow.slot.Slot;
import java.util.Arrays;
import java.util.List;

public abstract class NodeExecutor {
    protected final LFLog LOG = LFLoggerManager.getLogger(this.getClass());

    public void execute(NodeComponent instance) throws Exception {
        int retryCount = instance.getRetryCount();
        List<Class<? extends Exception>> forExceptions = Arrays.asList(instance.getRetryForExceptions());
        for (int i = 0; i <= retryCount; ++i) {
            try {
                if (i == 0) {
                    instance.execute();
                    break;
                }
                this.retry(instance, i);
                break;
            }
            catch (ChainEndException e) {
                throw e;
            }
            catch (Exception e) {
                boolean flag = forExceptions.stream().anyMatch(clazz -> clazz.isAssignableFrom(e.getClass()));
                if (flag && i < retryCount) continue;
                throw e;
            }
        }
    }

    protected void retry(NodeComponent instance, int currentRetryCount) throws Exception {
        Slot slot = DataBus.getSlot(instance.getSlotIndex());
        this.LOG.info("component[{}] performs {} retry", (Object)instance.getDisplayName(), (Object)(currentRetryCount + 1));
        instance.execute();
    }
}

