/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.liteflow.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jxdinfo.hutool.core.util.ObjectUtil;
import com.jxdinfo.hutool.core.util.StrUtil;
import com.jxdinfo.liteflow.exception.JsonProcessException;
import com.jxdinfo.liteflow.log.LFLog;
import com.jxdinfo.liteflow.log.LFLoggerManager;
import java.io.IOException;
import java.util.TimeZone;

public class JsonUtil {
    private static final LFLog LOG = LFLoggerManager.getLogger(JsonUtil.class);
    private static final ObjectMapper objectMapper = new ObjectMapper();

    private JsonUtil() {
    }

    public static String toJsonString(Object object) {
        if (ObjectUtil.isNull(object)) {
            return null;
        }
        try {
            return objectMapper.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            String errMsg = StrUtil.format("Error while writing value as string[{}],reason: {}", object.getClass().getName(), e.getMessage());
            LOG.error(e.getMessage(), e);
            throw new JsonProcessException(errMsg);
        }
    }

    public static JsonNode parseObject(String text) {
        if (StrUtil.isEmpty(text)) {
            return null;
        }
        try {
            return objectMapper.readTree(text);
        }
        catch (IOException e) {
            String errMsg = StrUtil.format("Error while parsing text [{}],reason: {}", text, e.getMessage());
            LOG.error(e.getMessage(), e);
            throw new JsonProcessException(errMsg);
        }
    }

    public static <T> T parseObject(String json, Class<T> clazz) {
        if (StrUtil.isEmpty(json)) {
            return null;
        }
        try {
            return (T)objectMapper.readValue(json, clazz);
        }
        catch (IOException e) {
            String errMsg = StrUtil.format("Error while parsing text [{}],reason: {}", json, e.getMessage());
            LOG.error(e.getMessage(), e);
            throw new JsonProcessException(errMsg);
        }
    }

    static {
        objectMapper.setTimeZone(TimeZone.getDefault());
        objectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
    }
}

