/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.conversion.converter;

import com.jxdinfo.conversion.TypeConverter;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.springframework.beans.factory.InitializingBean;

public class LocalDateTime2StringTypeConverter
implements TypeConverter<LocalDateTime, String>,
InitializingBean {
    private DateTimeFormatter dateTimeFormatter;

    public void afterPropertiesSet() {
        this.dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    }

    @Override
    public Class<LocalDateTime> getSourceType() {
        return LocalDateTime.class;
    }

    @Override
    public Class<String> getTargetType() {
        return String.class;
    }

    @Override
    public String getConvertName() {
        return "LOCAL_DATETIME_TO_STRING";
    }

    @Override
    public String doConvert(LocalDateTime source, Class<?> needType) {
        return this.dateTimeFormatter.format(source);
    }
}

