/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.liteflow.util;

import com.jxdinfo.hutool.core.io.FileUtil;
import com.jxdinfo.hutool.core.text.AntPathMatcher;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class PathMatchUtil {
    public static List<String> searchAbsolutePath(List<String> pathList) {
        ArrayList<String> absolutePathList = new ArrayList<String>();
        block0: for (String path : pathList) {
            if (FileUtil.isAbsolutePath(path)) {
                if (!path.contains("*")) {
                    absolutePathList.add(path);
                    continue;
                }
                String[] pathSegments = path.split("/");
                StringBuilder baseDir = new StringBuilder();
                for (int i = 0; i < pathSegments.length; ++i) {
                    if (pathSegments[i].contains("*")) {
                        baseDir.deleteCharAt(baseDir.length() - 1);
                        PathMatchUtil.searchAbsolutePath(baseDir.toString(), path, absolutePathList);
                        continue block0;
                    }
                    baseDir.append(pathSegments[i]).append(File.separator);
                }
                continue;
            }
            absolutePathList.add(path);
        }
        List<String> newAbsolutePathList = absolutePathList.stream().distinct().collect(Collectors.toList());
        return newAbsolutePathList;
    }

    private static void searchAbsolutePath(String baseDir, String path, List<String> absolutePathList) {
        AntPathMatcher pathMatcher = new AntPathMatcher();
        File dir = new File(baseDir);
        File[] files = dir.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    PathMatchUtil.searchAbsolutePath(file.getAbsolutePath(), path, absolutePathList);
                    continue;
                }
                String absolutePath = file.getAbsolutePath().replace("\\", "/");
                if (!pathMatcher.match(path, absolutePath)) continue;
                absolutePathList.add(absolutePath);
            }
        }
    }
}

