/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.liteflow.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.concurrent.PriorityBlockingQueue;

public class BoundedPriorityBlockingQueue<E>
extends PriorityBlockingQueue<E> {
    private static final long serialVersionUID = -1L;
    private final int capacity;
    private final Comparator<? super E> comparator;

    public BoundedPriorityBlockingQueue(int capacity) {
        this(capacity, null);
    }

    public BoundedPriorityBlockingQueue(int capacity, Comparator<? super E> comparator) {
        super(capacity, (o1, o2) -> {
            int cResult;
            if (comparator != null) {
                cResult = comparator.compare(o1, o2);
            } else {
                Comparable o1c = (Comparable)o1;
                cResult = o1c.compareTo(o2);
            }
            return -cResult;
        });
        this.capacity = capacity;
        this.comparator = comparator;
    }

    @Override
    public boolean offer(E e) {
        if (this.size() >= this.capacity) {
            Object head = this.peek();
            if (this.comparator().compare(e, head) <= 0) {
                return true;
            }
            this.poll();
        }
        return super.offer(e);
    }

    public boolean addAll(E[] c) {
        return this.addAll(Arrays.asList(c));
    }

    public ArrayList<E> toList() {
        ArrayList<? super E> list = new ArrayList<E>(this);
        list.sort(this.comparator);
        return list;
    }

    @Override
    public Iterator<E> iterator() {
        return this.toList().iterator();
    }
}

