/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.liteflow.flow.parallel;

import com.jxdinfo.liteflow.flow.element.Executable;
import com.jxdinfo.liteflow.flow.parallel.WhenFutureObj;
import com.jxdinfo.liteflow.log.LFLog;
import com.jxdinfo.liteflow.log.LFLoggerManager;
import java.util.function.Supplier;

public class ParallelSupplier
implements Supplier<WhenFutureObj> {
    private static final LFLog LOG = LFLoggerManager.getLogger(ParallelSupplier.class);
    private final Executable executableItem;
    private final String currChainId;
    private final Integer slotIndex;

    public ParallelSupplier(Executable executableItem, String currChainId, Integer slotIndex) {
        this.executableItem = executableItem;
        this.currChainId = currChainId;
        this.slotIndex = slotIndex;
    }

    @Override
    public WhenFutureObj get() {
        try {
            this.executableItem.setCurrChainId(this.currChainId);
            this.executableItem.execute(this.slotIndex);
            return WhenFutureObj.success(this.executableItem.getId());
        }
        catch (Exception e) {
            return WhenFutureObj.fail(this.executableItem.getId(), e);
        }
    }
}

