/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.liteflow.flow.element.condition;

import com.jxdinfo.hutool.core.text.StrFormatter;
import com.jxdinfo.hutool.core.util.ObjectUtil;
import com.jxdinfo.liteflow.exception.ChainEndException;
import com.jxdinfo.liteflow.flow.element.Chain;
import com.jxdinfo.liteflow.flow.element.Condition;
import com.jxdinfo.liteflow.flow.element.Executable;
import com.jxdinfo.liteflow.flow.element.Node;
import com.jxdinfo.liteflow.flow.element.condition.ThenCondition;
import com.jxdinfo.liteflow.log.LFLog;
import com.jxdinfo.liteflow.log.LFLoggerManager;
import com.jxdinfo.liteflow.slot.DataBus;
import java.util.Arrays;
import java.util.List;

public class RetryCondition
extends ThenCondition {
    private final LFLog LOG = LFLoggerManager.getLogger(this.getClass());
    private Integer retryTimes;
    private Class<? extends Exception>[] retryForExceptions = new Class[]{Exception.class};

    public Class<? extends Exception>[] getRetryForExceptions() {
        return this.retryForExceptions;
    }

    public void setRetryForExceptions(Class<? extends Exception>[] retryForExceptions) {
        this.retryForExceptions = retryForExceptions;
    }

    public Integer getRetryTimes() {
        return this.retryTimes;
    }

    public void setRetryTimes(Integer retryTimes) {
        this.retryTimes = retryTimes;
    }

    @Override
    public void executeCondition(Integer slotIndex) throws Exception {
        int retryTimes = this.getRetryTimes() < 0 ? 0 : this.getRetryTimes();
        List<Class<? extends Exception>> forExceptions = Arrays.asList(this.getRetryForExceptions());
        for (int i = 0; i <= retryTimes; ++i) {
            try {
                if (i == 0) {
                    super.executeCondition(slotIndex);
                    break;
                }
                this.retry(slotIndex, i);
                break;
            }
            catch (ChainEndException e) {
                throw e;
            }
            catch (Exception e) {
                boolean flag = forExceptions.stream().anyMatch(clazz -> clazz.isAssignableFrom(e.getClass()));
                if (!flag || i >= retryTimes) {
                    if (retryTimes > 0) {
                        String retryFailMsg = StrFormatter.format("retry fail when executing the chain[{}] because {} occurs {}.", this.getCurrChainId(), this.getCurrentExecutableId(), e);
                        this.LOG.error(retryFailMsg);
                    }
                    throw e;
                }
                DataBus.getSlot(slotIndex).removeException();
                continue;
            }
        }
    }

    private void retry(Integer slotIndex, int retryTime) throws Exception {
        this.LOG.info("{} performs {} retry ", (Object)this.getCurrentExecutableId(), (Object)retryTime);
        super.executeCondition(slotIndex);
    }

    private String getCurrentExecutableId() {
        Executable executable = this.getExecutableList().get(0);
        if (ObjectUtil.isNotNull(executable.getId())) {
            return executable.getId();
        }
        switch (executable.getExecuteType()) {
            case CHAIN: {
                return ((Chain)executable).getChainId();
            }
            case CONDITION: {
                return "condition-" + ((Condition)executable).getConditionType().getName();
            }
            case NODE: {
                return "node-" + ((Node)executable).getType().getCode();
            }
        }
        return "unknown-executable";
    }
}

