/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.liteflow.builder.el;

import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jxdinfo.hutool.core.collection.CollUtil;
import com.jxdinfo.hutool.core.util.ArrayUtil;
import com.jxdinfo.hutool.core.util.ObjectUtil;
import com.jxdinfo.hutool.core.util.StrUtil;
import com.jxdinfo.liteflow.builder.el.operator.AndOperator;
import com.jxdinfo.liteflow.builder.el.operator.AnyOperator;
import com.jxdinfo.liteflow.builder.el.operator.BreakOperator;
import com.jxdinfo.liteflow.builder.el.operator.CatchOperator;
import com.jxdinfo.liteflow.builder.el.operator.DataOperator;
import com.jxdinfo.liteflow.builder.el.operator.DefaultOperator;
import com.jxdinfo.liteflow.builder.el.operator.DoOperator;
import com.jxdinfo.liteflow.builder.el.operator.ElifOperator;
import com.jxdinfo.liteflow.builder.el.operator.ElseOperator;
import com.jxdinfo.liteflow.builder.el.operator.FinallyOperator;
import com.jxdinfo.liteflow.builder.el.operator.ForOperator;
import com.jxdinfo.liteflow.builder.el.operator.IdOperator;
import com.jxdinfo.liteflow.builder.el.operator.IfOperator;
import com.jxdinfo.liteflow.builder.el.operator.IgnoreErrorOperator;
import com.jxdinfo.liteflow.builder.el.operator.IteratorOperator;
import com.jxdinfo.liteflow.builder.el.operator.MaxWaitMillisecondsOperator;
import com.jxdinfo.liteflow.builder.el.operator.MaxWaitSecondsOperator;
import com.jxdinfo.liteflow.builder.el.operator.MustOperator;
import com.jxdinfo.liteflow.builder.el.operator.NodeOperator;
import com.jxdinfo.liteflow.builder.el.operator.NotOperator;
import com.jxdinfo.liteflow.builder.el.operator.OrOperator;
import com.jxdinfo.liteflow.builder.el.operator.ParallelOperator;
import com.jxdinfo.liteflow.builder.el.operator.PreOperator;
import com.jxdinfo.liteflow.builder.el.operator.RetryOperator;
import com.jxdinfo.liteflow.builder.el.operator.SwitchOperator;
import com.jxdinfo.liteflow.builder.el.operator.TagOperator;
import com.jxdinfo.liteflow.builder.el.operator.ThenOperator;
import com.jxdinfo.liteflow.builder.el.operator.ThreadPoolOperator;
import com.jxdinfo.liteflow.builder.el.operator.ToOperator;
import com.jxdinfo.liteflow.builder.el.operator.WhenOperator;
import com.jxdinfo.liteflow.builder.el.operator.WhileOperator;
import com.jxdinfo.liteflow.common.entity.ValidationResp;
import com.jxdinfo.liteflow.enums.ParseModeEnum;
import com.jxdinfo.liteflow.exception.CyclicDependencyException;
import com.jxdinfo.liteflow.exception.ELParseException;
import com.jxdinfo.liteflow.exception.FlowSystemException;
import com.jxdinfo.liteflow.exception.ParseException;
import com.jxdinfo.liteflow.exception.RouteELInvalidException;
import com.jxdinfo.liteflow.flow.FlowBus;
import com.jxdinfo.liteflow.flow.element.Chain;
import com.jxdinfo.liteflow.flow.element.Condition;
import com.jxdinfo.liteflow.flow.element.Executable;
import com.jxdinfo.liteflow.flow.element.Node;
import com.jxdinfo.liteflow.flow.element.condition.AndOrCondition;
import com.jxdinfo.liteflow.flow.element.condition.NotCondition;
import com.jxdinfo.liteflow.log.LFLog;
import com.jxdinfo.liteflow.log.LFLoggerManager;
import com.jxdinfo.liteflow.property.LiteflowConfig;
import com.jxdinfo.liteflow.property.LiteflowConfigGetter;
import com.jxdinfo.liteflow.util.ElRegexUtil;
import com.ql.util.express.DefaultContext;
import com.ql.util.express.ExpressRunner;
import com.ql.util.express.IExpressContext;
import com.ql.util.express.InstructionSet;
import com.ql.util.express.exception.QLException;
import com.ql.util.express.instruction.op.OperatorBase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class LiteFlowChainELBuilder {
    private static final LFLog LOG = LFLoggerManager.getLogger(LiteFlowChainELBuilder.class);
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private Chain chain = new Chain();
    private Executable route;
    private final List<Condition> conditionList = new ArrayList<Condition>();
    public static final ExpressRunner EXPRESS_RUNNER = new ExpressRunner();

    public static LiteFlowChainELBuilder createChain() {
        return new LiteFlowChainELBuilder();
    }

    public LiteFlowChainELBuilder setChainName(String chainName) {
        if (FlowBus.containChain(chainName)) {
            this.chain = FlowBus.getChain(chainName);
        } else {
            this.chain.setChainName(chainName);
        }
        return this;
    }

    public LiteFlowChainELBuilder setChainId(String chainId) {
        if (FlowBus.containChain(chainId)) {
            this.chain = FlowBus.getChain(chainId);
        } else {
            this.chain.setChainId(chainId);
        }
        return this;
    }

    public LiteFlowChainELBuilder setRoute(String routeEl) {
        if (StrUtil.isBlank(routeEl)) {
            return this;
        }
        ArrayList errorList = new ArrayList();
        try {
            DefaultContext context = new DefaultContext();
            FlowBus.getNodeMap().keySet().forEach(nodeId -> context.put(nodeId, (Object)FlowBus.getNode(nodeId)));
            Executable routeExecutable = (Executable)EXPRESS_RUNNER.execute(routeEl, (IExpressContext)context, errorList, true, true);
            if (!(routeExecutable instanceof AndOrCondition || routeExecutable instanceof NotCondition || routeExecutable instanceof Node)) {
                throw new RouteELInvalidException("the route EL can only be a boolean node, or an AND or OR expression.");
            }
            this.route = routeExecutable;
            return this;
        }
        catch (QLException e) {
            if (ObjectUtil.isNotNull(e.getCause()) && Objects.equals(e.getCause().getMessage(), "DataNotFoundException")) {
                String msg = LiteFlowChainELBuilder.buildDataNotFoundExceptionMsg(routeEl);
                throw new ELParseException(msg);
            }
            if (ObjectUtil.isNotNull(e.getCause())) {
                throw new ELParseException(e.getCause().getMessage());
            }
            throw new ELParseException(e.getMessage());
        }
        catch (RouteELInvalidException e) {
            throw e;
        }
        catch (Exception e) {
            String errMsg = StrUtil.format("parse el fail in this chain[{}];\r\n", this.chain.getChainId());
            throw new ELParseException(errMsg + e.getMessage());
        }
    }

    public LiteFlowChainELBuilder setEL(String elStr) {
        if (StrUtil.isBlank(elStr)) {
            String errMsg = StrUtil.format("no el in this chain[{}]", this.chain.getChainId());
            throw new FlowSystemException(errMsg);
        }
        this.chain.setEl(elStr);
        LiteflowConfig liteflowConfig = LiteflowConfigGetter.get();
        if (liteflowConfig.getParseMode().equals((Object)ParseModeEnum.PARSE_ONE_ON_FIRST_EXEC)) {
            this.chain.setCompiled(false);
            return this;
        }
        ArrayList errorList = new ArrayList();
        try {
            DefaultContext context = new DefaultContext();
            FlowBus.getChainMap().values().forEach(chain -> context.put((Object)chain.getChainId(), chain));
            FlowBus.getNodeMap().keySet().forEach(nodeId -> context.put(nodeId, (Object)FlowBus.getNode(nodeId)));
            context.put((Object)"currChainId", (Object)this.chain.getChainId());
            Condition condition = (Condition)EXPRESS_RUNNER.execute(elStr, (IExpressContext)context, errorList, true, true);
            if (Objects.isNull(condition)) {
                throw new QLException(StrUtil.format("parse el fail,el:[{}]", elStr));
            }
            this.conditionList.add(condition);
            return this;
        }
        catch (QLException e) {
            if (ObjectUtil.isNotNull(e.getCause()) && Objects.equals(e.getCause().getMessage(), "DataNotFoundException")) {
                String msg = LiteFlowChainELBuilder.buildDataNotFoundExceptionMsg(elStr);
                throw new ELParseException(msg);
            }
            if (ObjectUtil.isNotNull(e.getCause())) {
                throw new ELParseException(e.getCause().getMessage());
            }
            throw new ELParseException(e.getMessage());
        }
        catch (Exception e) {
            String errMsg = StrUtil.format("parse el fail in this chain[{}];\r\n", this.chain.getChainId());
            throw new ELParseException(errMsg + e.getMessage());
        }
    }

    public LiteFlowChainELBuilder setNamespace(String nameSpace) {
        if (StrUtil.isBlank(nameSpace)) {
            nameSpace = "default";
        }
        this.chain.setNamespace(nameSpace);
        return this;
    }

    @Deprecated
    public static boolean validate(String elStr) {
        return LiteFlowChainELBuilder.validateWithEx(elStr).isSuccess();
    }

    public static ValidationResp validateWithEx(String elStr) {
        ValidationResp resp = new ValidationResp();
        try {
            elStr = ElRegexUtil.removeComments(elStr);
            LiteFlowChainELBuilder.createChain().setEL(elStr);
            resp.setSuccess(true);
        }
        catch (Exception e) {
            LOG.error("\u9a8c\u8bc1\u5931\u8d25", e);
            resp.setSuccess(false);
            resp.setCause(e);
        }
        return resp;
    }

    public void build() {
        this.chain.setRouteItem(this.route);
        this.chain.setConditionList(this.conditionList);
        FlowBus.addChain(this.chain);
    }

    private void checkBuild() {
        ArrayList<String> errorList = new ArrayList<String>();
        if (StrUtil.isBlank(this.chain.getChainId())) {
            errorList.add("name is blank");
        }
        if (CollUtil.isNotEmpty(errorList)) {
            throw new RuntimeException(CollUtil.join(errorList, ",", "[", "]"));
        }
        try {
            objectMapper.writeValueAsString((Object)this.chain);
        }
        catch (Exception e) {
            if (e instanceof JsonMappingException) {
                throw new CyclicDependencyException(StrUtil.format("There is a circular dependency in the chain[{}], please check carefully.", this.chain.getChainId(), e));
            }
            throw new ParseException(e.getMessage());
        }
    }

    private static String buildDataNotFoundExceptionMsg(String elStr) {
        String msg = String.format("[node/chain is not exist or node/chain not register]\n EL: %s", StrUtil.trim(elStr));
        try {
            InstructionSet parseResult = EXPRESS_RUNNER.getInstructionSetFromLocalCache(elStr);
            if (parseResult == null) {
                return msg;
            }
            String[] outAttrNames = parseResult.getOutAttrNames();
            if (ArrayUtil.isEmpty(outAttrNames)) {
                return msg;
            }
            List<String> chainIds = CollUtil.map(FlowBus.getChainMap().values(), Chain::getChainId, true);
            List<String> nodeIds = CollUtil.map(FlowBus.getNodeMap().values(), Node::getId, true);
            for (String attrName : outAttrNames) {
                if (chainIds.contains(attrName) || nodeIds.contains(attrName)) continue;
                msg = String.format("[%s] is not exist or [%s] is not registered, you need to define a node or chain with id [%s] and register it \n EL: ", attrName, attrName, attrName);
                String sourceEl = StrUtil.removeAll((CharSequence)elStr, ' ', '\n', '\r');
                int commaRightIndex = sourceEl.indexOf(attrName + ",");
                if (commaRightIndex != -1) {
                    return msg + sourceEl + "\n" + StrUtil.fill("^", ' ', commaRightIndex + 6, true);
                }
                int commaLeftIndex = sourceEl.indexOf("," + attrName);
                if (commaLeftIndex != -1) {
                    return msg + sourceEl + "\n" + StrUtil.fill("^", ' ', commaLeftIndex + 7, true);
                }
                int nodeIndex = sourceEl.indexOf(String.format("node(\"%s\")", attrName));
                if (nodeIndex == -1) continue;
                return msg + sourceEl + "\n" + StrUtil.fill("^", ' ', commaLeftIndex + 12, true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return msg;
    }

    public static void buildUnCompileChain(Chain chain) {
        if (StrUtil.isBlank(chain.getEl())) {
            throw new FlowSystemException(StrUtil.format("no el content in this unCompile chain[{}]", chain.getChainId()));
        }
        if (CollUtil.isNotEmpty(chain.getConditionList())) {
            return;
        }
        ArrayList errorList = new ArrayList();
        try {
            DefaultContext context = new DefaultContext();
            FlowBus.getChainMap().values().forEach(chainItem -> context.put((Object)chainItem.getChainId(), chainItem));
            FlowBus.getNodeMap().keySet().forEach(nodeId -> context.put(nodeId, (Object)FlowBus.getNode(nodeId)));
            context.put((Object)"currChainId", (Object)chain.getChainId());
            String[] itemArray = EXPRESS_RUNNER.getOutVarNames(chain.getEl());
            Arrays.stream(itemArray).forEach(item -> {
                Chain itemChain;
                if (FlowBus.containChain(item) && !(itemChain = FlowBus.getChain(item)).isCompiled()) {
                    LiteFlowChainELBuilder.buildUnCompileChain(FlowBus.getChain(item));
                }
            });
            Condition condition = (Condition)EXPRESS_RUNNER.execute(chain.getEl(), (IExpressContext)context, errorList, true, true);
            if (Objects.isNull(condition)) {
                throw new QLException(StrUtil.format("parse el fail,el:[{}]", chain.getEl()));
            }
            chain.setConditionList(CollUtil.toList(condition));
            chain.setCompiled(true);
            FlowBus.addChain(chain);
        }
        catch (QLException e) {
            if (ObjectUtil.isNotNull(e.getCause()) && Objects.equals(e.getCause().getMessage(), "DataNotFoundException")) {
                String msg = LiteFlowChainELBuilder.buildDataNotFoundExceptionMsg(chain.getEl());
                throw new ELParseException(msg);
            }
            if (ObjectUtil.isNotNull(e.getCause())) {
                throw new ELParseException(e.getCause().getMessage());
            }
            throw new ELParseException(e.getMessage());
        }
        catch (Exception e) {
            String errMsg = StrUtil.format("parse el fail in this chain[{}];\r\n", chain.getChainId());
            throw new ELParseException(errMsg + e.getMessage());
        }
    }

    static {
        EXPRESS_RUNNER.addFunction("THEN", (OperatorBase)new ThenOperator());
        EXPRESS_RUNNER.addFunction("WHEN", (OperatorBase)new WhenOperator());
        EXPRESS_RUNNER.addFunction("SER", (OperatorBase)new ThenOperator());
        EXPRESS_RUNNER.addFunction("PAR", (OperatorBase)new WhenOperator());
        EXPRESS_RUNNER.addFunction("SWITCH", (OperatorBase)new SwitchOperator());
        EXPRESS_RUNNER.addFunction("PRE", (OperatorBase)new PreOperator());
        EXPRESS_RUNNER.addFunction("FINALLY", (OperatorBase)new FinallyOperator());
        EXPRESS_RUNNER.addFunction("IF", (OperatorBase)new IfOperator());
        EXPRESS_RUNNER.addFunction("node".toUpperCase(), (OperatorBase)new NodeOperator());
        EXPRESS_RUNNER.addFunction("node", (OperatorBase)new NodeOperator());
        EXPRESS_RUNNER.addFunction("FOR", (OperatorBase)new ForOperator());
        EXPRESS_RUNNER.addFunction("WHILE", (OperatorBase)new WhileOperator());
        EXPRESS_RUNNER.addFunction("ITERATOR", (OperatorBase)new IteratorOperator());
        EXPRESS_RUNNER.addFunction("CATCH", (OperatorBase)new CatchOperator());
        EXPRESS_RUNNER.addFunction("AND", (OperatorBase)new AndOperator());
        EXPRESS_RUNNER.addFunction("OR", (OperatorBase)new OrOperator());
        EXPRESS_RUNNER.addFunction("NOT", (OperatorBase)new NotOperator());
        EXPRESS_RUNNER.addFunctionAndClassMethod("ELSE", Object.class, (OperatorBase)new ElseOperator());
        EXPRESS_RUNNER.addFunctionAndClassMethod("ELIF", Object.class, (OperatorBase)new ElifOperator());
        EXPRESS_RUNNER.addFunctionAndClassMethod("TO", Object.class, (OperatorBase)new ToOperator());
        EXPRESS_RUNNER.addFunctionAndClassMethod("TO".toLowerCase(), Object.class, (OperatorBase)new ToOperator());
        EXPRESS_RUNNER.addFunctionAndClassMethod("DEFAULT", Object.class, (OperatorBase)new DefaultOperator());
        EXPRESS_RUNNER.addFunctionAndClassMethod("tag", Object.class, (OperatorBase)new TagOperator());
        EXPRESS_RUNNER.addFunctionAndClassMethod("any", Object.class, (OperatorBase)new AnyOperator());
        EXPRESS_RUNNER.addFunctionAndClassMethod("must", Object.class, (OperatorBase)new MustOperator());
        EXPRESS_RUNNER.addFunctionAndClassMethod("id", Object.class, (OperatorBase)new IdOperator());
        EXPRESS_RUNNER.addFunctionAndClassMethod("ignoreError", Object.class, (OperatorBase)new IgnoreErrorOperator());
        EXPRESS_RUNNER.addFunctionAndClassMethod("threadPool", Object.class, (OperatorBase)new ThreadPoolOperator());
        EXPRESS_RUNNER.addFunctionAndClassMethod("DO", Object.class, (OperatorBase)new DoOperator());
        EXPRESS_RUNNER.addFunctionAndClassMethod("BREAK", Object.class, (OperatorBase)new BreakOperator());
        EXPRESS_RUNNER.addFunctionAndClassMethod("data", Object.class, (OperatorBase)new DataOperator());
        EXPRESS_RUNNER.addFunctionAndClassMethod("maxWaitSeconds", Object.class, (OperatorBase)new MaxWaitSecondsOperator());
        EXPRESS_RUNNER.addFunctionAndClassMethod("maxWaitMilliseconds", Object.class, (OperatorBase)new MaxWaitMillisecondsOperator());
        EXPRESS_RUNNER.addFunctionAndClassMethod("parallel", Object.class, (OperatorBase)new ParallelOperator());
        EXPRESS_RUNNER.addFunctionAndClassMethod("retry", Object.class, (OperatorBase)new RetryOperator());
    }
}

