/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hutool.core.util;

import com.jxdinfo.hutool.core.convert.BasicType;
import com.jxdinfo.hutool.core.exceptions.UtilException;
import com.jxdinfo.hutool.core.lang.Assert;
import com.jxdinfo.hutool.core.map.SafeConcurrentHashMap;
import com.jxdinfo.hutool.core.util.StrUtil;
import java.lang.reflect.Array;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Map;

public class ClassLoaderUtil {
    private static final String ARRAY_SUFFIX = "[]";
    private static final String INTERNAL_ARRAY_PREFIX = "[";
    private static final String NON_PRIMITIVE_ARRAY_PREFIX = "[L";
    private static final char PACKAGE_SEPARATOR = '.';
    private static final char INNER_CLASS_SEPARATOR = '$';
    private static final Map<String, Class<?>> PRIMITIVE_TYPE_NAME_MAP = new SafeConcurrentHashMap(32);

    public static ClassLoader getContextClassLoader() {
        if (System.getSecurityManager() == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return AccessController.doPrivileged(() -> Thread.currentThread().getContextClassLoader());
    }

    public static ClassLoader getSystemClassLoader() {
        if (System.getSecurityManager() == null) {
            return ClassLoader.getSystemClassLoader();
        }
        return AccessController.doPrivileged(ClassLoader::getSystemClassLoader);
    }

    public static ClassLoader getClassLoader() {
        ClassLoader classLoader = ClassLoaderUtil.getContextClassLoader();
        if (classLoader == null && null == (classLoader = ClassLoaderUtil.class.getClassLoader())) {
            classLoader = ClassLoaderUtil.getSystemClassLoader();
        }
        return classLoader;
    }

    public static Class<?> loadClass(String name, boolean isInitialized) throws UtilException {
        return ClassLoaderUtil.loadClass(name, null, isInitialized);
    }

    public static Class<?> loadClass(String name, ClassLoader classLoader, boolean isInitialized) throws UtilException {
        Class<?> clazz;
        Assert.notNull(name, "Name must not be null", new Object[0]);
        name = name.replace('/', '.');
        if (null == classLoader) {
            classLoader = ClassLoaderUtil.getClassLoader();
        }
        if ((clazz = ClassLoaderUtil.loadPrimitiveClass(name)) == null) {
            clazz = ClassLoaderUtil.doLoadClass(name, classLoader, isInitialized);
        }
        return clazz;
    }

    public static Class<?> loadPrimitiveClass(String name) {
        Class<?> result = null;
        if (StrUtil.isNotBlank(name) && (name = name.trim()).length() <= 8) {
            result = PRIMITIVE_TYPE_NAME_MAP.get(name);
        }
        return result;
    }

    private static Class<?> doLoadClass(String name, ClassLoader classLoader, boolean isInitialized) {
        Class<?> clazz;
        block9: {
            if (name.endsWith(ARRAY_SUFFIX)) {
                String elementClassName = name.substring(0, name.length() - ARRAY_SUFFIX.length());
                Class<?> elementClass = ClassLoaderUtil.loadClass(elementClassName, classLoader, isInitialized);
                clazz = Array.newInstance(elementClass, 0).getClass();
            } else if (name.startsWith(NON_PRIMITIVE_ARRAY_PREFIX) && name.endsWith(";")) {
                String elementName = name.substring(NON_PRIMITIVE_ARRAY_PREFIX.length(), name.length() - 1);
                Class<?> elementClass = ClassLoaderUtil.loadClass(elementName, classLoader, isInitialized);
                clazz = Array.newInstance(elementClass, 0).getClass();
            } else if (name.startsWith(INTERNAL_ARRAY_PREFIX)) {
                String elementName = name.substring(INTERNAL_ARRAY_PREFIX.length());
                Class<?> elementClass = ClassLoaderUtil.loadClass(elementName, classLoader, isInitialized);
                clazz = Array.newInstance(elementClass, 0).getClass();
            } else {
                if (null == classLoader) {
                    classLoader = ClassLoaderUtil.getClassLoader();
                }
                try {
                    clazz = Class.forName(name, isInitialized, classLoader);
                }
                catch (ClassNotFoundException ex) {
                    clazz = ClassLoaderUtil.tryLoadInnerClass(name, classLoader, isInitialized);
                    if (null != clazz) break block9;
                    throw new UtilException(ex);
                }
            }
        }
        return clazz;
    }

    private static Class<?> tryLoadInnerClass(String name, ClassLoader classLoader, boolean isInitialized) {
        int lastDotIndex = name.lastIndexOf(46);
        if (lastDotIndex > 0) {
            String innerClassName = name.substring(0, lastDotIndex) + '$' + name.substring(lastDotIndex + 1);
            try {
                return Class.forName(innerClassName, isInitialized, classLoader);
            }
            catch (ClassNotFoundException ex2) {
                // empty catch block
            }
        }
        return null;
    }

    static {
        ArrayList primitiveTypes = new ArrayList(32);
        primitiveTypes.addAll(BasicType.PRIMITIVE_WRAPPER_MAP.keySet());
        primitiveTypes.add(boolean[].class);
        primitiveTypes.add(byte[].class);
        primitiveTypes.add(char[].class);
        primitiveTypes.add(double[].class);
        primitiveTypes.add(float[].class);
        primitiveTypes.add(int[].class);
        primitiveTypes.add(long[].class);
        primitiveTypes.add(short[].class);
        primitiveTypes.add(Void.TYPE);
        for (Class clazz : primitiveTypes) {
            PRIMITIVE_TYPE_NAME_MAP.put(clazz.getName(), clazz);
        }
    }
}

