/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hutool.core.io.file;

import com.jxdinfo.hutool.core.io.IORuntimeException;
import com.jxdinfo.hutool.core.io.IoUtil;
import com.jxdinfo.hutool.core.lang.Assert;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.AccessDeniedException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;

public class PathUtil {
    public static List<File> loopFiles(Path path, int maxDepth, FileFilter fileFilter) {
        return PathUtil.loopFiles(path, maxDepth, false, fileFilter);
    }

    public static List<File> loopFiles(Path path, int maxDepth, boolean isFollowLinks, final FileFilter fileFilter) {
        final ArrayList<File> fileList = new ArrayList<File>();
        if (!PathUtil.exists(path, isFollowLinks)) {
            return fileList;
        }
        if (!PathUtil.isDirectory(path, isFollowLinks)) {
            File file = path.toFile();
            if (null == fileFilter || fileFilter.accept(file)) {
                fileList.add(file);
            }
            return fileList;
        }
        PathUtil.walkFiles(path, maxDepth, isFollowLinks, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) {
                File file = path.toFile();
                if (null == fileFilter || fileFilter.accept(file)) {
                    fileList.add(file);
                }
                return FileVisitResult.CONTINUE;
            }
        });
        return fileList;
    }

    public static void walkFiles(Path start, int maxDepth, FileVisitor<? super Path> visitor) {
        PathUtil.walkFiles(start, maxDepth, false, visitor);
    }

    public static void walkFiles(Path start, int maxDepth, boolean isFollowLinks, FileVisitor<? super Path> visitor) {
        if (maxDepth < 0) {
            maxDepth = Integer.MAX_VALUE;
        }
        try {
            Files.walkFileTree(start, PathUtil.getFileVisitOption(isFollowLinks), maxDepth, visitor);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static Path copyFile(Path src, Path target, CopyOption ... options) throws IORuntimeException {
        Assert.notNull(src, "Source File is null !", new Object[0]);
        Assert.notNull(target, "Destination File or directory is null !", new Object[0]);
        Path targetPath = PathUtil.isDirectory(target) ? target.resolve(src.getFileName()) : target;
        PathUtil.mkParentDirs(targetPath);
        try {
            return Files.copy(src, targetPath, options);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static boolean isDirectory(Path path) {
        return PathUtil.isDirectory(path, false);
    }

    public static boolean isDirectory(Path path, boolean isFollowLinks) {
        if (null == path) {
            return false;
        }
        return Files.isDirectory(path, PathUtil.getLinkOptions(isFollowLinks));
    }

    public static Path getPathEle(Path path, int index) {
        return PathUtil.subPath(path, index, index == -1 ? path.getNameCount() : index + 1);
    }

    public static Path getLastPathEle(Path path) {
        return PathUtil.getPathEle(path, path.getNameCount() - 1);
    }

    public static Path subPath(Path path, int fromIndex, int toIndex) {
        if (null == path) {
            return null;
        }
        int len = path.getNameCount();
        if (fromIndex < 0) {
            if ((fromIndex = len + fromIndex) < 0) {
                fromIndex = 0;
            }
        } else if (fromIndex > len) {
            fromIndex = len;
        }
        if (toIndex < 0) {
            if ((toIndex = len + toIndex) < 0) {
                toIndex = len;
            }
        } else if (toIndex > len) {
            toIndex = len;
        }
        if (toIndex < fromIndex) {
            int tmp = fromIndex;
            fromIndex = toIndex;
            toIndex = tmp;
        }
        if (fromIndex == toIndex) {
            return null;
        }
        return path.subpath(fromIndex, toIndex);
    }

    public static BufferedInputStream getInputStream(Path path) throws IORuntimeException {
        InputStream in;
        try {
            in = Files.newInputStream(path, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        return IoUtil.toBuffered(in);
    }

    public static BufferedReader getReader(Path path, Charset charset) throws IORuntimeException {
        return IoUtil.getReader((InputStream)PathUtil.getInputStream(path), charset);
    }

    public static byte[] readBytes(Path path) {
        try {
            return Files.readAllBytes(path);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static boolean equals(Path file1, Path file2) throws IORuntimeException {
        try {
            return Files.isSameFile(file1, file2);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static boolean isSymlink(Path path) {
        return Files.isSymbolicLink(path);
    }

    public static boolean exists(Path path, boolean isFollowLinks) {
        return Files.exists(path, PathUtil.getLinkOptions(isFollowLinks));
    }

    public static boolean isSub(Path parent, Path sub) {
        return PathUtil.toAbsNormal(sub).startsWith(PathUtil.toAbsNormal(parent));
    }

    public static Path toAbsNormal(Path path) {
        Assert.notNull(path);
        return path.toAbsolutePath().normalize();
    }

    public static String getMimeType(Path file) {
        try {
            return Files.probeContentType(file);
        }
        catch (IOException ignore) {
            return null;
        }
    }

    public static Path mkdir(Path dir) {
        if (null != dir && !PathUtil.exists(dir, false)) {
            try {
                Files.createDirectories(dir, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new IORuntimeException(e);
            }
        }
        return dir;
    }

    public static Path mkParentDirs(Path path) {
        return PathUtil.mkdir(path.getParent());
    }

    public static String getName(Path path) {
        if (null == path) {
            return null;
        }
        return path.getFileName().toString();
    }

    public static Path createTempFile(String prefix, String suffix, Path dir) throws IORuntimeException {
        int exceptionsCount = 0;
        while (true) {
            try {
                if (null == dir) {
                    return Files.createTempFile(prefix, suffix, new FileAttribute[0]);
                }
                return Files.createTempFile(PathUtil.mkdir(dir), prefix, suffix, new FileAttribute[0]);
            }
            catch (IOException ioex) {
                if (++exceptionsCount < 50) continue;
                throw new IORuntimeException(ioex);
            }
            break;
        }
    }

    protected static void delFile(Path path) throws IOException {
        block2: {
            try {
                Files.delete(path);
            }
            catch (AccessDeniedException e) {
                if (path.toFile().delete()) break block2;
                throw e;
            }
        }
    }

    public static LinkOption[] getLinkOptions(boolean isFollowLinks) {
        LinkOption[] linkOptionArray;
        if (isFollowLinks) {
            linkOptionArray = new LinkOption[]{};
        } else {
            LinkOption[] linkOptionArray2 = new LinkOption[1];
            linkOptionArray = linkOptionArray2;
            linkOptionArray2[0] = LinkOption.NOFOLLOW_LINKS;
        }
        return linkOptionArray;
    }

    public static Set<FileVisitOption> getFileVisitOption(boolean isFollowLinks) {
        return isFollowLinks ? EnumSet.of(FileVisitOption.FOLLOW_LINKS) : EnumSet.noneOf(FileVisitOption.class);
    }
}

