/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hutool.core.io;

import com.jxdinfo.hutool.core.collection.LineIter;
import com.jxdinfo.hutool.core.exceptions.UtilException;
import com.jxdinfo.hutool.core.io.FastByteArrayOutputStream;
import com.jxdinfo.hutool.core.io.IORuntimeException;
import com.jxdinfo.hutool.core.io.LineHandler;
import com.jxdinfo.hutool.core.io.NioUtil;
import com.jxdinfo.hutool.core.io.StreamProgress;
import com.jxdinfo.hutool.core.io.ValidateObjectInputStream;
import com.jxdinfo.hutool.core.io.copy.StreamCopier;
import com.jxdinfo.hutool.core.lang.Assert;
import com.jxdinfo.hutool.core.util.StrUtil;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.Serializable;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.Collection;

public class IoUtil
extends NioUtil {
    public static long copy(InputStream in, OutputStream out) throws IORuntimeException {
        return IoUtil.copy(in, out, 8192);
    }

    public static long copy(InputStream in, OutputStream out, int bufferSize) throws IORuntimeException {
        return IoUtil.copy(in, out, bufferSize, null);
    }

    public static long copy(InputStream in, OutputStream out, int bufferSize, StreamProgress streamProgress) throws IORuntimeException {
        return IoUtil.copy(in, out, bufferSize, -1L, streamProgress);
    }

    public static long copy(InputStream in, OutputStream out, int bufferSize, long count, StreamProgress streamProgress) throws IORuntimeException {
        return new StreamCopier(bufferSize, count, streamProgress).copy(in, out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long copy(FileInputStream in, FileOutputStream out) throws IORuntimeException {
        long l;
        Assert.notNull(in, "FileInputStream is null!", new Object[0]);
        Assert.notNull(out, "FileOutputStream is null!", new Object[0]);
        FileChannel inChannel = null;
        FileChannel outChannel = null;
        try {
            inChannel = in.getChannel();
            outChannel = out.getChannel();
            l = IoUtil.copy(inChannel, outChannel);
        }
        catch (Throwable throwable) {
            IoUtil.close(outChannel);
            IoUtil.close(inChannel);
            throw throwable;
        }
        IoUtil.close(outChannel);
        IoUtil.close(inChannel);
        return l;
    }

    @Deprecated
    public static BufferedReader getReader(InputStream in, String charsetName) {
        return IoUtil.getReader(in, Charset.forName(charsetName));
    }

    public static BufferedReader getReader(InputStream in, Charset charset) {
        if (null == in) {
            return null;
        }
        InputStreamReader reader = null == charset ? new InputStreamReader(in) : new InputStreamReader(in, charset);
        return new BufferedReader(reader);
    }

    public static BufferedReader getReader(Reader reader) {
        if (null == reader) {
            return null;
        }
        return reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
    }

    public static PushbackReader getPushBackReader(Reader reader, int pushBackSize) {
        return reader instanceof PushbackReader ? (PushbackReader)reader : new PushbackReader(reader, pushBackSize);
    }

    @Deprecated
    public static OutputStreamWriter getWriter(OutputStream out, String charsetName) {
        return IoUtil.getWriter(out, Charset.forName(charsetName));
    }

    public static OutputStreamWriter getWriter(OutputStream out, Charset charset) {
        if (null == out) {
            return null;
        }
        if (null == charset) {
            return new OutputStreamWriter(out);
        }
        return new OutputStreamWriter(out, charset);
    }

    public static String read(InputStream in, Charset charset) throws IORuntimeException {
        return StrUtil.str(IoUtil.readBytes(in), charset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FastByteArrayOutputStream read(InputStream in, boolean isClose) throws IORuntimeException {
        FastByteArrayOutputStream out;
        if (in instanceof FileInputStream) {
            try {
                out = new FastByteArrayOutputStream(in.available());
            }
            catch (IOException e) {
                throw new IORuntimeException(e);
            }
        } else {
            out = new FastByteArrayOutputStream();
        }
        try {
            IoUtil.copy(in, out);
        }
        finally {
            if (isClose) {
                IoUtil.close(in);
            }
        }
        return out;
    }

    public static String read(Reader reader) throws IORuntimeException {
        return IoUtil.read(reader, true);
    }

    public static String read(Reader reader, boolean isClose) throws IORuntimeException {
        StringBuilder builder = StrUtil.builder();
        CharBuffer buffer = CharBuffer.allocate(8192);
        try {
            while (-1 != reader.read(buffer)) {
                builder.append(buffer.flip());
            }
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        finally {
            if (isClose) {
                IoUtil.close(reader);
            }
        }
        return builder.toString();
    }

    public static byte[] readBytes(InputStream in) throws IORuntimeException {
        return IoUtil.readBytes(in, true);
    }

    public static byte[] readBytes(InputStream in, boolean isClose) throws IORuntimeException {
        return IoUtil.read(in, isClose).toByteArray();
    }

    public static <T> T readObj(InputStream in) throws IORuntimeException, UtilException {
        return IoUtil.readObj(in, null);
    }

    public static <T> T readObj(InputStream in, Class<T> clazz) throws IORuntimeException, UtilException {
        try {
            return IoUtil.readObj(in instanceof ValidateObjectInputStream ? (ValidateObjectInputStream)in : new ValidateObjectInputStream(in, new Class[0]), clazz);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static <T> T readObj(ValidateObjectInputStream in, Class<T> clazz) throws IORuntimeException, UtilException {
        if (in == null) {
            throw new IllegalArgumentException("The InputStream must not be null");
        }
        if (null != clazz) {
            in.accept(clazz);
        }
        try {
            return (T)in.readObject();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            throw new UtilException(e);
        }
    }

    public static <T extends Collection<String>> T readLines(InputStream in, Charset charset, T collection) throws IORuntimeException {
        return IoUtil.readLines((Reader)IoUtil.getReader(in, charset), collection);
    }

    public static <T extends Collection<String>> T readLines(Reader reader, T collection) throws IORuntimeException {
        IoUtil.readLines(reader, collection::add);
        return collection;
    }

    public static void readLines(Reader reader, LineHandler lineHandler) throws IORuntimeException {
        Assert.notNull(reader);
        Assert.notNull(lineHandler);
        for (String line : IoUtil.lineIter(reader)) {
            lineHandler.handle(line);
        }
    }

    public static FileInputStream toStream(File file) {
        try {
            return new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new IORuntimeException(e);
        }
    }

    public static BufferedInputStream toBuffered(InputStream in) {
        Assert.notNull(in, "InputStream must be not null!", new Object[0]);
        return in instanceof BufferedInputStream ? (BufferedInputStream)in : new BufferedInputStream(in);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void writeObjects(OutputStream out, boolean isCloseOut, Serializable ... contents) throws IORuntimeException {
        ObjectOutputStream osw = null;
        try {
            osw = out instanceof ObjectOutputStream ? (ObjectOutputStream)out : new ObjectOutputStream(out);
            for (Serializable content : contents) {
                if (content == null) continue;
                osw.writeObject(content);
            }
            osw.flush();
            if (!isCloseOut) return;
        }
        catch (IOException e) {
            try {
                throw new IORuntimeException(e);
            }
            catch (Throwable throwable) {
                if (!isCloseOut) throw throwable;
                IoUtil.close(osw);
                throw throwable;
            }
        }
        IoUtil.close(osw);
        return;
    }

    public static void close(Closeable closeable) {
        if (null != closeable) {
            try {
                closeable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static LineIter lineIter(Reader reader) {
        return new LineIter(reader);
    }
}

