/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.conversion.converter;

import com.jxdinfo.conversion.TypeConverter;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.springframework.beans.factory.InitializingBean;

public class String2LocalDateTimeTypeConverter
implements TypeConverter<String, LocalDateTime>,
InitializingBean {
    private DateTimeFormatter dateTimeFormatter;

    public void afterPropertiesSet() {
        this.dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    }

    @Override
    public LocalDateTime doConvert(String source, Class<?> needType) {
        return LocalDateTime.parse(source, this.dateTimeFormatter);
    }

    @Override
    public Class<String> getSourceType() {
        return String.class;
    }

    @Override
    public Class<LocalDateTime> getTargetType() {
        return LocalDateTime.class;
    }

    @Override
    public String getConvertName() {
        return "STRING_TO_LOCAL_DATETIME";
    }
}

