/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.conversion.utils;

import com.jxdinfo.conversion.exception.ConversionException;
import com.jxdinfo.hutool.core.util.StrUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ElementParserUtil {
    private static final Map<Class<?>, Object> PRIMITIVE_INIT_MAP = new HashMap();
    private static final Map<Class<?>, Object> PRIMITIVE_PACK_TYPE = new HashMap();

    public static Object initPrimitive(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        return PRIMITIVE_INIT_MAP.get(clazz);
    }

    public static Optional<Object> newInstance(Class<?> clazz) {
        if (clazz == null) {
            return Optional.empty();
        }
        try {
            return Optional.of(clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (Throwable e) {
            throw new ConversionException(StrUtil.format("\u53c2\u6570\u8f6c\u6362\u5931\u8d25\uff0c class: {}", clazz.getName()), e);
        }
    }

    public static boolean isAssignable(Class<?> left, Class<?> right) {
        if (left == null || right == null) {
            return false;
        }
        if (left == right) {
            return true;
        }
        if (Objects.equals("void", left.getName()) || Objects.equals("void", right.getName())) {
            return false;
        }
        if (left.isPrimitive()) {
            left = (Class)PRIMITIVE_PACK_TYPE.get(left);
        }
        if (right.isPrimitive()) {
            right = (Class)PRIMITIVE_PACK_TYPE.get(right);
        }
        return left.isAssignableFrom(right);
    }

    static {
        PRIMITIVE_INIT_MAP.put(Long.TYPE, 0L);
        PRIMITIVE_INIT_MAP.put(Integer.TYPE, 0);
        PRIMITIVE_INIT_MAP.put(Short.TYPE, (short)0);
        PRIMITIVE_INIT_MAP.put(Byte.TYPE, (byte)0);
        PRIMITIVE_INIT_MAP.put(Character.TYPE, Character.valueOf('\u0000'));
        PRIMITIVE_INIT_MAP.put(Double.TYPE, 0.0);
        PRIMITIVE_INIT_MAP.put(Float.TYPE, Float.valueOf(0.0f));
        PRIMITIVE_INIT_MAP.put(Boolean.TYPE, false);
        PRIMITIVE_PACK_TYPE.put(Long.TYPE, Long.class);
        PRIMITIVE_PACK_TYPE.put(Integer.TYPE, Integer.class);
        PRIMITIVE_PACK_TYPE.put(Short.TYPE, Short.class);
        PRIMITIVE_PACK_TYPE.put(Byte.TYPE, Byte.class);
        PRIMITIVE_PACK_TYPE.put(Character.TYPE, Character.class);
        PRIMITIVE_PACK_TYPE.put(Double.TYPE, Double.class);
        PRIMITIVE_PACK_TYPE.put(Float.TYPE, Float.class);
        PRIMITIVE_PACK_TYPE.put(Boolean.TYPE, Boolean.class);
    }
}

