/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.liteflow.thread;

import com.jxdinfo.hutool.core.map.MapUtil;
import com.jxdinfo.hutool.core.util.ObjectUtil;
import com.jxdinfo.hutool.core.util.StrUtil;
import com.jxdinfo.liteflow.exception.ThreadExecutorServiceCreateException;
import com.jxdinfo.liteflow.log.LFLog;
import com.jxdinfo.liteflow.log.LFLoggerManager;
import com.jxdinfo.liteflow.property.LiteflowConfig;
import com.jxdinfo.liteflow.property.LiteflowConfigGetter;
import com.jxdinfo.liteflow.spi.holder.ContextAwareHolder;
import com.jxdinfo.liteflow.thread.ExecutorBuilder;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;

public class ExecutorHelper {
    private final LFLog LOG = LFLoggerManager.getLogger(ExecutorHelper.class);
    private final Map<String, ExecutorService> executorServiceMap = MapUtil.newConcurrentHashMap();

    private ExecutorHelper() {
    }

    public static ExecutorHelper loadInstance() {
        return Holder.INSTANCE;
    }

    public void shutdownAwaitTermination(ExecutorService pool) {
        this.shutdownAwaitTermination(pool, 60L);
    }

    public void shutdownAwaitTermination(ExecutorService pool, long timeout) {
        pool.shutdown();
        try {
            if (!pool.awaitTermination(timeout, TimeUnit.SECONDS)) {
                pool.shutdownNow();
                if (!pool.awaitTermination(timeout, TimeUnit.SECONDS)) {
                    this.LOG.error("Pool did not terminate.");
                }
            }
        }
        catch (InterruptedException ie) {
            pool.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    public ExecutorService buildWhenExecutor() {
        LiteflowConfig liteflowConfig = LiteflowConfigGetter.get();
        return this.buildWhenExecutor(liteflowConfig.getThreadExecutorClass());
    }

    public ExecutorService buildWhenExecutor(String clazz) {
        if (StrUtil.isBlank(clazz)) {
            return this.buildWhenExecutor();
        }
        return this.getExecutorService(clazz);
    }

    public ExecutorService buildWhenExecutorWithHash(String conditionHash) {
        LiteflowConfig liteflowConfig = LiteflowConfigGetter.get();
        return this.buildWhenExecutorWithHash(liteflowConfig.getThreadExecutorClass(), conditionHash);
    }

    public ExecutorService buildWhenExecutorWithHash(String clazz, String conditionHash) {
        if (StrUtil.isBlank(clazz)) {
            return this.buildWhenExecutorWithHash(conditionHash);
        }
        return this.getExecutorService(clazz, conditionHash);
    }

    public ExecutorService buildMainExecutor() {
        LiteflowConfig liteflowConfig = LiteflowConfigGetter.get();
        return this.buildMainExecutor(liteflowConfig.getMainExecutorClass());
    }

    public ExecutorService buildMainExecutor(String clazz) {
        if (StrUtil.isBlank(clazz)) {
            return this.buildMainExecutor();
        }
        return this.getExecutorService(clazz);
    }

    public ExecutorService buildLoopParallelExecutor() {
        LiteflowConfig liteflowConfig = LiteflowConfigGetter.get();
        return this.getExecutorService(liteflowConfig.getParallelLoopExecutorClass());
    }

    private ExecutorService getExecutorService(String clazz) {
        return this.getExecutorService(clazz, null);
    }

    private ExecutorService getExecutorService(String clazz, String conditionHash) {
        try {
            String key = StrUtil.isBlank(conditionHash) ? clazz : StrUtil.format("{}_{}", clazz, conditionHash);
            ExecutorService executorServiceFromCache = this.executorServiceMap.get(key);
            if (ObjectUtil.isNotNull(executorServiceFromCache)) {
                return executorServiceFromCache;
            }
            Class<?> executorClass = Class.forName(clazz);
            ExecutorBuilder executorBuilder = (ExecutorBuilder)ContextAwareHolder.loadContextAware().registerBean(executorClass);
            ExecutorService executorService = executorBuilder.buildExecutor();
            this.executorServiceMap.put(key, executorService);
            return executorService;
        }
        catch (Exception e) {
            this.LOG.error(e.getMessage());
            throw new ThreadExecutorServiceCreateException(e.getMessage());
        }
    }

    public void clearExecutorServiceMap() {
        if (MapUtil.isNotEmpty(this.executorServiceMap)) {
            this.executorServiceMap.clear();
        }
    }

    private static class Holder {
        static final ExecutorHelper INSTANCE = new ExecutorHelper();

        private Holder() {
        }
    }
}

