/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hutool.core.text;

import com.jxdinfo.hutool.core.text.finder.CharFinder;
import com.jxdinfo.hutool.core.text.finder.StrFinder;
import com.jxdinfo.hutool.core.text.split.SplitIter;
import com.jxdinfo.hutool.core.util.StrUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

public class StrSplitter {
    public static List<String> split(CharSequence str, char separator, boolean isTrim, boolean ignoreEmpty) {
        return StrSplitter.split(str, separator, 0, isTrim, ignoreEmpty);
    }

    public static List<String> split(CharSequence str, char separator, int limit, boolean isTrim, boolean ignoreEmpty) {
        return StrSplitter.split(str, separator, limit, isTrim, ignoreEmpty, false);
    }

    public static List<String> split(CharSequence text, char separator, int limit, boolean isTrim, boolean ignoreEmpty, boolean ignoreCase) {
        return StrSplitter.split(text, separator, limit, ignoreEmpty, ignoreCase, StrSplitter.trimFunc(isTrim));
    }

    public static <R> List<R> split(CharSequence text, char separator, int limit, boolean ignoreEmpty, boolean ignoreCase, Function<String, R> mapping) {
        if (null == text) {
            return new ArrayList(0);
        }
        SplitIter splitIter = new SplitIter(text, new CharFinder(separator, ignoreCase), limit, ignoreEmpty);
        return splitIter.toList(mapping);
    }

    public static String[] splitToArray(CharSequence str, char separator, int limit, boolean isTrim, boolean ignoreEmpty) {
        return StrSplitter.toArray(StrSplitter.split(str, separator, limit, isTrim, ignoreEmpty));
    }

    public static List<String> split(CharSequence str, String separator, int limit, boolean isTrim, boolean ignoreEmpty) {
        return StrSplitter.split(str, separator, limit, isTrim, ignoreEmpty, false);
    }

    public static List<String> split(CharSequence text, String separator, int limit, boolean isTrim, boolean ignoreEmpty, boolean ignoreCase) {
        if (null == text) {
            return new ArrayList<String>(0);
        }
        SplitIter splitIter = new SplitIter(text, new StrFinder(separator, ignoreCase), limit, ignoreEmpty);
        return splitIter.toList(isTrim);
    }

    public static String[] splitToArray(CharSequence str, String separator, int limit, boolean isTrim, boolean ignoreEmpty) {
        return StrSplitter.toArray(StrSplitter.split(str, separator, limit, isTrim, ignoreEmpty));
    }

    private static String[] toArray(List<String> list) {
        return list.toArray(new String[0]);
    }

    private static Function<String, String> trimFunc(boolean isTrim) {
        return str -> isTrim ? StrUtil.trim(str) : str;
    }
}

